/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.timedpromise.internal.bootstrap;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.util.runners.SealedRunner;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.timedpromise.internal.AtlassianSchedulerFacade;
import com.atlassian.scheduler.timedpromise.internal.TimedPromiseExecutor;
import com.atlassian.scheduler.timedpromise.internal.TimedPromisePruner;
import com.atlassian.scheduler.timedpromise.internal.history.TimedPromiseHistoryPruner;
import com.atlassian.scheduler.timedpromise.internal.log.LogLeveller;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class TimedPromiseLauncher
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(TimedPromiseLauncher.class);
    private static final String PLUGIN_KEY = "com.atlassian.plugin.timedpromise.atlassian-timed-promise-plugin";
    private static final String PLUGIN_STARTED_EVENT = "plugin.started.event";
    private static final String LIFECYCLE_AWARE_ONSTART = "lifecycle.aware.onstart";
    private final EventPublisher eventPublisher;
    private final TimedPromiseExecutor timedPromiseExecutor;
    private final TimedPromisePruner timedPromisePruner;
    private final TimedPromiseHistoryPruner timedPromiseHistoryPruner;
    private final AtlassianSchedulerFacade scheduler;
    private LazyReference<SealedRunner> sealedStartCompleteRunner = new LazyReference<SealedRunner>(){

        protected SealedRunner create() throws Exception {
            return new SealedRunner(Arrays.asList(TimedPromiseLauncher.PLUGIN_STARTED_EVENT, TimedPromiseLauncher.LIFECYCLE_AWARE_ONSTART), () -> TimedPromiseLauncher.this.onStartCompleted());
        }
    };

    @Autowired
    public TimedPromiseLauncher(EventPublisher eventPublisher, TimedPromiseExecutor timedPromiseExecutor, TimedPromisePruner timedPromisePruner, TimedPromiseHistoryPruner timedPromiseHistoryPruner, AtlassianSchedulerFacade scheduler) {
        this.eventPublisher = eventPublisher;
        this.timedPromiseExecutor = timedPromiseExecutor;
        this.timedPromisePruner = timedPromisePruner;
        this.timedPromiseHistoryPruner = timedPromiseHistoryPruner;
        this.scheduler = scheduler;
        LogLeveller.setInfo((Logger)log);
    }

    @PostConstruct
    public void onSpringContextStarted() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public final void onPluginStarted(PluginEnabledEvent pluginEnabledEvent) {
        if (pluginEnabledEvent.getPlugin().getKey().equals(PLUGIN_KEY)) {
            ((SealedRunner)this.sealedStartCompleteRunner.get()).breakSeal(PLUGIN_STARTED_EVENT);
        }
    }

    public void onStart() {
        ((SealedRunner)this.sealedStartCompleteRunner.get()).breakSeal(LIFECYCLE_AWARE_ONSTART);
    }

    @VisibleForTesting
    void onStartCompleted() {
        log.info("Timed Promises is initializing...");
        this.tenantlessSetup();
        this.tenantedSetup();
        log.info("Timed Promises is initialized.");
    }

    public void onStop() {
        log.info("Timed Promises spring context is stopping...");
        this.tenantedShutdown();
        this.tenantlessShutDown();
        log.info("Timed Promises spring context is stopped.");
    }

    @EventListener
    public final void onClearCache(Object event) {
        if (event.getClass().getName().equals("com.atlassian.jira.event.ClearCacheEvent") && ((SealedRunner)this.sealedStartCompleteRunner.get()).hasRun()) {
            this.onJiraClearCache();
        }
    }

    private void onJiraClearCache() {
        log.info("Timed Promises is clearing it caches...");
        this.scheduler.unscheduleJobsOnShutDown();
        this.scheduler.unregisterJobRunners();
        this.scheduler.registerJobRunners(this.timedPromiseExecutor, this.timedPromisePruner, this.timedPromiseHistoryPruner);
        this.scheduler.scheduleJobsOnInitialisation();
        log.info("Timed Promises has cleared it caches.");
    }

    private void tenantlessSetup() {
        this.scheduler.registerJobRunners(this.timedPromiseExecutor, this.timedPromisePruner, this.timedPromiseHistoryPruner);
    }

    private void tenantedSetup() {
        this.scheduler.scheduleJobsOnInitialisation();
    }

    private void tenantedShutdown() {
        this.scheduler.unscheduleJobsOnShutDown();
    }

    private void tenantlessShutDown() {
        this.eventPublisher.unregister((Object)this);
        this.scheduler.unregisterJobRunners();
    }
}

