/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.chaperone;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;

public class ChaperonePinManager {
    private final UserManager userManager;
    private PluginSettingsFactory pluginSettingsFactory;

    public ChaperonePinManager(UserManager userManager, PluginSettingsFactory pluginSettingsFactory) {
        this.userManager = userManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    private String getUniqueKey(String key) {
        return "chaperone:" + key + ":" + this.userManager.getRemoteUsername();
    }

    public void setValue(String key, String value) {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        settings.put(this.getUniqueKey(key), (Object)value);
    }

    public Object getValue(String key) {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        return settings.get(this.getUniqueKey(key));
    }
}

