/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.widgets;

import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoogleGadgetsRenderer
implements WidgetRenderer {
    private static final Pattern PATTERN = Pattern.compile("url=([^&]+)&?");
    private static final String VELOCITY_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/googlegadgets.vm";
    private static final String DEFAULT_WIDTH = "410px";
    private static final String DEFAULT_HEIGHT = "342px";
    private VelocityRenderService velocityRenderService;
    private static final String MATCH_URL = "google.com/ig";

    public GoogleGadgetsRenderer(VelocityRenderService velocityRenderService) {
        this.velocityRenderService = velocityRenderService;
    }

    public String getEmbedUrl(String url) {
        Matcher m = PATTERN.matcher(url);
        if (m.find()) {
            String gadgetUrl = m.group(1);
            if (!gadgetUrl.startsWith("http")) {
                gadgetUrl = "//".concat(gadgetUrl);
            }
            return gadgetUrl;
        }
        return null;
    }

    @Override
    public boolean matches(String url) {
        return url.contains(MATCH_URL);
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        if (!params.containsKey("width")) {
            params.put("width", DEFAULT_WIDTH);
        }
        if (!params.containsKey("height")) {
            params.put("height", DEFAULT_HEIGHT);
        }
        params.put("_template", VELOCITY_TEMPLATE);
        return this.velocityRenderService.render(this.getEmbedUrl(url), params);
    }
}

