/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.video;

import com.atlassian.confluence.extra.widgetconnector.WidgetImagePlaceholder;
import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.PlaceholderService;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import com.atlassian.confluence.macro.ImagePlaceholder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class YoutubeRenderer
implements WidgetRenderer,
WidgetImagePlaceholder {
    private static final Pattern YOUTUBE_URL_PATTERN = Pattern.compile("https?://(.+\\.)?youtube.com.*(\\?v=([^&]+)).*$");
    private VelocityRenderService velocityRenderService;
    private final PlaceholderService placeholderService;
    private final String DEFAULT_YOUTUBE_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/youtube.vm";
    private final String DEFAULT_WIDTH = "400px";
    private final String DEFAULT_HEIGHT = "300px";
    private final String PIXEL = "px";
    private final String MAX_RES_THUMBNAIL = "maxresdefault.jpg";
    private final String HIGH_QUALITY_THUMBNAIL = "hqdefault.jpg";
    private final String MED_QUALITY_THUMBNAIL = "mqdefault.jpg";
    private final String LOW_QUALITY_THUMBNAIL = "default.jpg";

    public YoutubeRenderer(VelocityRenderService velocityRenderService, PlaceholderService placeholderService) {
        this.velocityRenderService = velocityRenderService;
        this.placeholderService = placeholderService;
    }

    public String getEmbedUrl(String url) {
        Matcher youtubeUrlMatcher = YOUTUBE_URL_PATTERN.matcher(this.verifyEmbeddedPlayerString(url));
        return youtubeUrlMatcher.matches() ? String.format("//www.youtube.com/embed/%s?wmode=opaque", youtubeUrlMatcher.group(3)) : null;
    }

    @Override
    public boolean matches(String url) {
        return YOUTUBE_URL_PATTERN.matcher(this.verifyEmbeddedPlayerString(url)).matches();
    }

    private String verifyEmbeddedPlayerString(String url) {
        return !url.contains("feature=player_embedded&") ? url : url.replace("feature=player_embedded&", "");
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        return this.velocityRenderService.render(this.getEmbedUrl(url), this.setDefaultParam(params));
    }

    private Map<String, String> setDefaultParam(Map<String, String> params) {
        String width = params.get("width");
        String height = params.get("height");
        if (!params.containsKey("_template")) {
            params.put("_template", "com/atlassian/confluence/extra/widgetconnector/templates/youtube.vm");
        }
        if (StringUtils.isEmpty((String)width)) {
            params.put("width", "400px");
        } else if (StringUtils.isNumeric((String)width)) {
            params.put("width", width.concat("px"));
        }
        if (StringUtils.isEmpty((String)height)) {
            params.put("height", "300px");
        } else if (StringUtils.isNumeric((String)height)) {
            params.put("height", height.concat("px"));
        }
        return params;
    }

    private Map<String, String> populateImagePlaceholderParam(Map<String, String> params) {
        params = this.setDefaultParam(params);
        params.put("overlay", "youtube");
        return params;
    }

    private String getThumbnailUrl(String url) {
        Matcher youtubeUrlMatcher = YOUTUBE_URL_PATTERN.matcher(url);
        return youtubeUrlMatcher.matches() ? String.format("http://img.youtube.com/vi/%s/mqdefault.jpg", youtubeUrlMatcher.group(3)) : null;
    }

    @Override
    public ImagePlaceholder getImagePlaceholder(String url, Map<String, String> params) {
        return this.placeholderService.generatePlaceholder(this.getThumbnailUrl(url), this.populateImagePlaceholderParam(params));
    }
}

