/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.video;

import com.atlassian.confluence.extra.widgetconnector.WidgetConnectorUtil;
import com.atlassian.confluence.extra.widgetconnector.WidgetImagePlaceholder;
import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import com.atlassian.confluence.extra.widgetconnector.video.OoyalaConfigurationManager;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class OoyalaRenderer
implements WidgetRenderer,
WidgetImagePlaceholder {
    private static final String MATCH_URL = "ooyala.com";
    private static final Pattern EMBED_CODE_PATTERN = Pattern.compile("^.*((\\?embedCode)|(\\#ec)|(\\#ooid))=([a-zA-Z0-9]+[-|_]?[a-zA-Z0-9]+).*$");
    private static final String VELOCITY_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/ooyala.vm";
    private static final String DEFAULT_WIDTH = "712px";
    private static final String DEFAULT_HEIGHT = "400px";
    private static final String PIXEL = "px";
    private final VelocityRenderService velocityRenderService;
    private final PermissionManager permissionManager;
    private final OoyalaConfigurationManager ooyalaConfigurationManager;

    public OoyalaRenderer(VelocityRenderService velocityRenderService, PermissionManager permissionManager, OoyalaConfigurationManager ooyalaConfigurationManager) {
        this.velocityRenderService = velocityRenderService;
        this.permissionManager = permissionManager;
        this.ooyalaConfigurationManager = ooyalaConfigurationManager;
    }

    @Override
    public boolean matches(String url) {
        return url.contains(MATCH_URL);
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        String embedCode;
        params.put("_template", VELOCITY_TEMPLATE);
        String brandingId = this.ooyalaConfigurationManager.getBrandingId();
        if (StringUtils.isNotBlank((String)brandingId)) {
            params.put("brandingId", brandingId);
        }
        if (StringUtils.isNotBlank((String)(embedCode = this.getEmbedCode(url)))) {
            params.put("embedCode", embedCode);
        }
        params.put("videoContainerId", RandomStringUtils.randomAlphabetic((int)8));
        params.put("currentUserAdmin", String.valueOf(this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM)));
        return this.velocityRenderService.render(this.getEmbedUrl(url, params), params);
    }

    private String getEmbedCode(String embedUrl) {
        Matcher embedCodeMatcher = EMBED_CODE_PATTERN.matcher(embedUrl);
        return embedCodeMatcher.matches() ? embedCodeMatcher.group(5) : "";
    }

    public String getEmbedUrl(String url, Map<String, String> params) {
        String embedCode = this.getEmbedCode(url);
        String width = params.get("width");
        String height = params.get("height");
        width = StringUtils.isEmpty((String)width) ? DEFAULT_WIDTH : (StringUtils.isNumeric((String)width) ? width.concat(PIXEL) : DEFAULT_WIDTH);
        height = StringUtils.isEmpty((String)height) ? DEFAULT_HEIGHT : (StringUtils.isNumeric((String)height) ? height.concat(PIXEL) : DEFAULT_HEIGHT);
        return "//player.ooyala.com/player.js?embedCode=" + embedCode + "&width=" + width + "&height=" + height;
    }

    @Override
    public ImagePlaceholder getImagePlaceholder(String url, Map<String, String> params) {
        return WidgetConnectorUtil.generateDefaultImagePlaceholder("player.ooyala.com");
    }
}

