/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.video;

import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.user.User;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class MySpaceVideoRenderer
implements WidgetRenderer {
    private static final Pattern OLD_MATCH_PATTERN = Pattern.compile("https?://vids.myspace\\.com.*$", 2);
    private static final Pattern MATCH_PATTERN = Pattern.compile("https?://(www.)?myspace\\.com.*$", 2);
    private static final Pattern PATTERN = Pattern.compile("https?://(www.)?myspace.com(/.+)?/video/(.+?)(/.+)?/(\\d+)", 2);
    private static final String VELOCITY_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/iframe.vm";
    private final VelocityRenderService velocityRenderService;
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;

    public MySpaceVideoRenderer(VelocityRenderService velocityRenderService, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager) {
        this.velocityRenderService = velocityRenderService;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
    }

    public String getEmbedUrl(String url) {
        Matcher urlMatcher = PATTERN.matcher(url);
        String videoName = "";
        String videoId = "";
        if (urlMatcher.matches()) {
            videoName = urlMatcher.group(4);
            if (videoName == null || videoName.length() == 0) {
                videoName = "/" + urlMatcher.group(3);
            }
            videoId = urlMatcher.group(5);
            if (videoName.length() > 0 && !videoName.endsWith("-")) {
                videoName = videoName + "-";
            }
        }
        return "//myspace.com/play/video" + videoName + videoId;
    }

    @Override
    public boolean matches(String url) {
        return MATCH_PATTERN.matcher(url).matches() || OLD_MATCH_PATTERN.matcher(url).matches();
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        String protocol;
        if (OLD_MATCH_PATTERN.matcher(url).matches()) {
            params.put("baseUrlHtml", this.getText("com.atlassian.confluence.extra.widgetconnector.myspace.outdated.url"));
            params.put("_template", "com/atlassian/confluence/extra/widgetconnector/templates/error.vm");
            return this.velocityRenderService.render(url, params);
        }
        String string = protocol = StringUtils.startsWith((String)url, (String)"https://") ? "https" : "http";
        if (StringUtils.startsWith((String)url, (String)"/")) {
            url = protocol + "://myspace.com" + url;
        }
        params.put("_template", VELOCITY_TEMPLATE);
        return this.velocityRenderService.render(this.getEmbedUrl(url), params);
    }

    public String getText(String i18nKey) {
        return this.getI18NBean().getText(i18nKey);
    }

    private I18NBean getI18NBean() {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
    }
}

