/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.video;

import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.http.HttpRequest;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.HttpRetrievalService;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EpisodicRenderer
implements WidgetRenderer {
    private static final String MATCH_URL = "episodic.com";
    private static final String PATTERN = "shows/(.+)/episodes/(.+)/?";
    private VelocityRenderService velocityRenderService;
    private HttpRetrievalService httpRetrievalService;

    public EpisodicRenderer(VelocityRenderService velocityRenderService, HttpRetrievalService httpRetrievalService) {
        this.velocityRenderService = velocityRenderService;
        this.httpRetrievalService = httpRetrievalService;
    }

    public String getEmbedUrl(String url) {
        Pattern p = Pattern.compile(PATTERN);
        Matcher m = p.matcher(url);
        String showId = "";
        String episodeId = "";
        String videoId = "";
        if (m.find()) {
            showId = m.group(1);
            episodeId = m.group(2);
        }
        try {
            videoId = this.isNewVideoFormat(showId, episodeId) ? showId + "%2F" + episodeId.substring(episodeId.length() - 1, episodeId.length()) + "%2F" + episodeId : showId + "%2F" + episodeId;
        }
        catch (IOException e) {
            return null;
        }
        return "//cdn.episodic.com/player/EpisodicPlayer.swf?config=http%3A%2F%2Fcdn.episodic.com%2Fshows%2F" + videoId + "%2fconfig.xml";
    }

    @Override
    public boolean matches(String url) {
        return url.contains(MATCH_URL);
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        return this.velocityRenderService.render(this.getEmbedUrl(url), params);
    }

    private boolean isNewVideoFormat(String showId, String episodeId) throws IOException {
        StringBuilder s = new StringBuilder();
        s.append("https://cdn.episodic.com/shows/");
        s.append(GeneralUtil.urlEncode((String)showId));
        s.append("/");
        s.append(GeneralUtil.urlEncode((String)episodeId));
        s.append("/config.xml");
        HttpRequest req = this.httpRetrievalService.getDefaultRequestFor(s.toString());
        HttpResponse resp = this.httpRetrievalService.get(req);
        return resp.isNotFound() || resp.isNotPermitted() || resp.isFailed();
    }
}

