/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.video;

import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.HttpRetrievalEmbedService;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class BlipRenderer
implements WidgetRenderer {
    private HttpRetrievalEmbedService httpRetrievalEmbedService;
    public static final String MATCH_URL = "blip.tv";
    public static final Pattern PATTERN = Pattern.compile("http://blip.tv/play/([^\\\\]+)");
    private VelocityRenderService velocityRenderService;

    public BlipRenderer(HttpRetrievalEmbedService httpRetrievalEmbedService, VelocityRenderService velocityRenderService) {
        this.httpRetrievalEmbedService = httpRetrievalEmbedService;
        this.velocityRenderService = velocityRenderService;
    }

    public String getEmbedUrl(String url) {
        String ajaxUrl = url + "?skin=json";
        String embedParameter = this.httpRetrievalEmbedService.getEmbedData(ajaxUrl, PATTERN, this.getClass().getName());
        if (StringUtils.isNotEmpty((String)embedParameter)) {
            return "//blip.tv/play/" + embedParameter;
        }
        return null;
    }

    @Override
    public boolean matches(String url) {
        return url.contains(MATCH_URL);
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        return this.velocityRenderService.render(this.getEmbedUrl(url), params);
    }
}

