/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.services;

import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DefaultVelocityRenderService
implements VelocityRenderService {
    private final String DEFAULT_WIDTH = "400";
    private final String DEFAULT_HEIGHT = "300";
    private final String DEFAULT_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/embed.vm";

    @Override
    public String render(String url, Map<String, String> params) {
        String width = params.get("width");
        String height = params.get("height");
        String template = params.get("_template");
        if (StringUtils.isEmpty((String)template)) {
            template = "com/atlassian/confluence/extra/widgetconnector/templates/embed.vm";
        }
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        Map<String, Object> contextMap = this.getDefaultVelocityContext();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getKey().contentEquals("tweetHtml")) {
                contextMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            contextMap.put(entry.getKey(), GeneralUtil.htmlEncode((String)entry.getValue()));
        }
        contextMap.put("urlHtml", GeneralUtil.htmlEncode((String)url));
        if (StringUtils.isNotEmpty((String)width)) {
            contextMap.put("width", GeneralUtil.htmlEncode((String)width));
        } else {
            contextMap.put("width", "400");
        }
        if (StringUtils.isNotEmpty((String)height)) {
            contextMap.put("height", GeneralUtil.htmlEncode((String)height));
        } else {
            contextMap.put("height", "300");
        }
        return this.getRenderedTemplate(template, contextMap);
    }

    protected String getRenderedTemplate(String template, Map<String, Object> contextMap) {
        return VelocityUtils.getRenderedTemplate((String)template, contextMap);
    }

    protected Map<String, Object> getDefaultVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }
}

