/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.services;

import com.atlassian.confluence.extra.widgetconnector.services.HttpRetrievalEmbedService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.HttpRetrievalService;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Logger;

public class DefaultHttpRetrievalEmbedService
implements HttpRetrievalEmbedService {
    private static final Logger log = Logger.getLogger(DefaultHttpRetrievalEmbedService.class);
    private final SettingsManager settingsManager;
    private final VCacheFactory cacheFactory;
    private final HttpRetrievalService httpRetrievalService;
    private final HttpConnectionManager httpConnectionManager;

    public DefaultHttpRetrievalEmbedService(SettingsManager settingsManager, VCacheFactory cacheFactory, HttpRetrievalService httpRetrievalService) {
        this.settingsManager = settingsManager;
        this.cacheFactory = cacheFactory;
        this.httpRetrievalService = httpRetrievalService;
        this.httpConnectionManager = new SimpleHttpConnectionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEmbedData(String url, Pattern pattern, String cacheName) {
        StableReadExternalCache<String> cache = this.getCache(cacheName);
        Optional result = (Optional)VCacheUtils.join((CompletionStage)cache.get(url));
        if (result.isPresent()) {
            return (String)result.get();
        }
        HttpResponse response = this.getResponse(url);
        try {
            String line;
            if (response == null) {
                String string = null;
                return string;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getResponse()));
            while ((line = br.readLine()) != null) {
                Matcher m = pattern.matcher(line);
                if (!m.find()) continue;
                br.close();
                String embedId = m.group(1);
                VCacheUtils.join((CompletionStage)this.getCache(cacheName).put(url, (Object)embedId, PutPolicy.PUT_ALWAYS));
                String string = embedId;
                return string;
            }
            br.close();
        }
        catch (IOException e) {
            log.error((Object)("An error occured parsing the response from: " + url));
        }
        finally {
            if (response != null) {
                response.finish();
            }
        }
        return null;
    }

    private HttpResponse getResponse(String url) {
        HttpResponse response = null;
        try {
            response = this.httpRetrievalService.get(url);
            if (response.isNotFound()) {
                log.error((Object)("URL not found: " + url));
                return null;
            }
            if (response.isNotPermitted()) {
                log.error((Object)("URL not permitted: " + url));
                return null;
            }
            if (response.isFailed()) {
                log.error((Object)("Failed to retrieve data from URL: " + url));
                return null;
            }
        }
        catch (IOException e) {
            log.error((Object)("Unable to retrieve " + url + ": " + e.getMessage()), (Throwable)e);
        }
        return response;
    }

    private StableReadExternalCache<String> getCache(String cacheName) {
        return this.cacheFactory.getStableReadExternalCache(cacheName, MarshallerFactory.serializableMarshaller(String.class), new ExternalCacheSettingsBuilder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNewLocation(String oldUrl) {
        HeadMethod headMethod = null;
        try {
            HttpClient client = this.getClient();
            headMethod = new HeadMethod(oldUrl);
            headMethod.setFollowRedirects(false);
            if (301 == client.executeMethod((HttpMethod)headMethod)) {
                String string = headMethod.getResponseHeader("Location").getValue();
                return string;
            }
        }
        catch (IOException ioError) {
            log.error((Object)String.format("IO error while trying to make a HEAD request to %s", oldUrl), (Throwable)ioError);
        }
        finally {
            if (null != headMethod) {
                headMethod.releaseConnection();
            }
        }
        return oldUrl;
    }

    private HttpClient getClient() {
        HttpConnectionManagerParams httpConnectionManagerParams = this.httpConnectionManager.getParams();
        if (null == httpConnectionManagerParams) {
            httpConnectionManagerParams = new HttpConnectionManagerParams();
        }
        ConfluenceHttpParameters confluenceHttpParameters = this.settingsManager.getGlobalSettings().getConfluenceHttpParameters();
        httpConnectionManagerParams.setConnectionTimeout(confluenceHttpParameters.getConnectionTimeout());
        httpConnectionManagerParams.setSoTimeout(confluenceHttpParameters.getSocketTimeout());
        return new HttpClient(this.httpConnectionManager);
    }
}

