/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.photo;

import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.HttpRetrievalEmbedService;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FlickrRenderer
implements WidgetRenderer {
    private static final String MATCH_URL = "flickr.com";
    private static final String VELOCITY_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/flickr.vm";
    public static final Pattern TAGS_PATTERN = Pattern.compile("/photos/tags/([^/]+)/?");
    public static final Pattern USER_PATTERN = Pattern.compile("/photos/([^/]+)/?(\\d+)?/?");
    public static final Pattern SET_PATTERN = Pattern.compile("/photos/([^/]+)/sets/(\\d+)/?");
    public static final Pattern PATTERN = Pattern.compile("id=([^&]+@[^&]+)&amp;");
    private static final String USERNAME_PLACEHOLDER = "[USER_NAME]";
    private static final String USERID_PLACEHOLDER = "[USER_ID]";
    private static final String SET_PLACEHOLDER = "[SET]";
    private static final String TAG_PLACEHOLDER = "[TAG]";
    private static final String JUMPTO_PLACEHOLDER = "[JUMPTO]";
    public static final String TAG_URL = "&offsite=true&intl_lang=en-us&page_show_url=%2Fphotos%2Ftags%2F[TAG]%2Fshow%2F&page_show_back_url=%2Fphotos%2Ftags%2F[TAG]%2F&tags=[TAG]&jump_to=&st[TAG]_index=";
    public static final String USER_URL = "&offsite=true&intl_lang=en-us&page_show_url=%2Fphotos%2F[USER_NAME]%2Fshow%2F&page_show_back_url=%2Fphotos%2F[USER_NAME]%2F&user_id=[USER_ID]&jump_to=";
    public static final String USER_URL_PIC = "&offsite=true&intl_lang=en-us&page_show_url=%2Fphotos%2F[USER_NAME]%2Fshow%2Fwith%2F[JUMPTO]%2F&page_show_back_url=%2Fphotos%2F[USER_NAME]%2Fwith%2F[JUMPTO]%2F&user_id=[USER_ID]&jump_to=[JUMPTO]";
    public static final String SET_URL = "&offsite=true&intl_lang=en-us&page_show_url=%2Fphotos%2F[USER_NAME]%2Fsets%2F[SET]%2Fshow%2F&page_show_back_url=%2Fphotos%2F[USER_NAME]%2Fsets%2F[SET]%2F&set_id=[SET]&jump_to=";
    private HttpRetrievalEmbedService httpRetrievalEmbedService;
    private VelocityRenderService velocityRenderService;

    public FlickrRenderer(HttpRetrievalEmbedService httpRetrievalEmbedService, VelocityRenderService velocityRenderService) {
        this.httpRetrievalEmbedService = httpRetrievalEmbedService;
        this.velocityRenderService = velocityRenderService;
    }

    public String getEmbedUrl(String url) {
        String displayUrl = null;
        Matcher m = USER_PATTERN.matcher(url);
        if (m.find() && !url.contains("photos/tags/")) {
            displayUrl = this.renderUser(m, url);
        }
        if ((m = SET_PATTERN.matcher(url)).find() && !url.contains("photos/tags/")) {
            displayUrl = this.renderSet(m);
        }
        if ((m = TAGS_PATTERN.matcher(url)).find()) {
            displayUrl = this.renderTag(m);
        }
        return displayUrl;
    }

    private String renderSet(Matcher m) {
        return SET_URL.replace(USERNAME_PLACEHOLDER, m.group(1)).replace(SET_PLACEHOLDER, m.group(2));
    }

    private String renderUser(Matcher m, String url) {
        String username = m.group(1);
        String jumpTo = m.group(2);
        String userId = this.httpRetrievalEmbedService.getEmbedData("https://www.flickr.com/photos/" + username, PATTERN, this.getClass().getName());
        if (userId == null) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)jumpTo)) {
            return USER_URL_PIC.replace(USERNAME_PLACEHOLDER, username).replace(USERID_PLACEHOLDER, userId).replace(JUMPTO_PLACEHOLDER, jumpTo);
        }
        return USER_URL.replace(USERNAME_PLACEHOLDER, username).replace(USERID_PLACEHOLDER, userId);
    }

    private String renderTag(Matcher m) {
        return TAG_URL.replace(TAG_PLACEHOLDER, m.group(1));
    }

    @Override
    public boolean matches(String url) {
        return url.contains(MATCH_URL);
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        params.put("_template", VELOCITY_TEMPLATE);
        return this.velocityRenderService.render(this.getEmbedUrl(url), params);
    }
}

