/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.documents;

import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.HttpRetrievalEmbedService;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SlideShareRenderer
implements WidgetRenderer {
    private HttpRetrievalEmbedService httpRetrievalEmbedService;
    public static final String MATCH_URL = "slideshare.net";
    public static final Pattern PATTERN = Pattern.compile("\"doc\":\"([^\"]+)");
    private static final String DEFAULT_WIDTH = "425";
    private static final String DEFAULT_HEIGHT = "355";
    private VelocityRenderService velocityRenderService;

    public SlideShareRenderer(HttpRetrievalEmbedService httpRetrievalEmbedService, VelocityRenderService velocityRenderService) {
        this.httpRetrievalEmbedService = httpRetrievalEmbedService;
        this.velocityRenderService = velocityRenderService;
    }

    public String getEmbedUrl(String url) {
        String embedParameter = this.httpRetrievalEmbedService.getEmbedData(url, PATTERN, this.getClass().getName());
        if (StringUtils.isNotEmpty((String)embedParameter)) {
            return "//static.slideshare.net/swf/ssplayer2.swf?doc=" + embedParameter;
        }
        return null;
    }

    @Override
    public boolean matches(String url) {
        return url.contains(MATCH_URL);
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        if (!params.containsKey("width")) {
            params.put("width", DEFAULT_WIDTH);
        }
        if (!params.containsKey("height")) {
            params.put("height", DEFAULT_HEIGHT);
        }
        return this.velocityRenderService.render(this.getEmbedUrl(url), params);
    }
}

