/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.documents;

import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShareAcrobat
implements WidgetRenderer {
    public static final String MATCH_URL = "share.acrobat.com";
    private static final Pattern PATTERN = Pattern.compile("docid=([^&]+)");
    public static final String VELOCITY_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/embed.vm";
    private VelocityRenderService velocityRenderService;
    private static final String EMBED_URL = "https://share.acrobat.com/adc/flex/mpt.swf";
    private static final String FLASHVARS_PARAM = "flashVars";
    private static final String DEFAULT_WIDTH = "365px";
    private static final String DEFAULT_HEIGHT = "500px";

    public ShareAcrobat(VelocityRenderService velocityRenderService) {
        this.velocityRenderService = velocityRenderService;
    }

    @Override
    public boolean matches(String url) {
        return url.contains(MATCH_URL);
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        params.put(FLASHVARS_PARAM, this.getFlashVars(url));
        if (!params.containsKey("width")) {
            params.put("width", DEFAULT_WIDTH);
        }
        if (!params.containsKey("height")) {
            params.put("height", DEFAULT_HEIGHT);
        }
        params.put("_template", VELOCITY_TEMPLATE);
        return this.velocityRenderService.render(EMBED_URL, params);
    }

    public String getFlashVars(String url) {
        Matcher m = PATTERN.matcher(url);
        String docId = "";
        if (m.find()) {
            docId = m.group(1);
        }
        return "docId=" + docId;
    }
}

