/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.documents;

import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.HttpRetrievalEmbedService;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScribdRenderer
implements WidgetRenderer {
    public static final String MATCH_URL = "scribd.com";
    public static final Pattern PATTERN = Pattern.compile("[doc|read]/(\\d+)/.+");
    public static final Pattern ACCESS_KEY_PATTERN = Pattern.compile("access_key\":\"([^\"]+)\"");
    private HttpRetrievalEmbedService httpRetrievalEmbedService;
    private static final String DEFAULT_WIDTH = "475";
    private static final String DEFAULT_HEIGHT = "355";
    public static final String VELOCITY_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/iframe.vm";
    private VelocityRenderService velocityRenderService;

    public ScribdRenderer(HttpRetrievalEmbedService httpRetrievalEmbedService, VelocityRenderService velocityRenderService) {
        this.httpRetrievalEmbedService = httpRetrievalEmbedService;
        this.velocityRenderService = velocityRenderService;
    }

    public String getDocId(String url) {
        Matcher m = PATTERN.matcher(url);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public String getEmbedUrl(String url) {
        Matcher m = PATTERN.matcher(url);
        if (m.find()) {
            String doc = m.group(1);
            String accessKey = this.httpRetrievalEmbedService.getEmbedData(url, ACCESS_KEY_PATTERN, this.getClass().getName());
            return "//www.scribd.com/embeds/" + doc + "/content?start_page=1&view_mode=scroll&access_key=" + accessKey + "&show_recommendations=false";
        }
        return null;
    }

    @Override
    public boolean matches(String url) {
        return url.contains(MATCH_URL);
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        params.put("_template", VELOCITY_TEMPLATE);
        params.put("nameHtml", this.getDocId(url));
        if (!params.containsKey("width")) {
            params.put("width", DEFAULT_WIDTH);
        }
        if (!params.containsKey("height")) {
            params.put("height", DEFAULT_HEIGHT);
        }
        return this.velocityRenderService.render(this.getEmbedUrl(url), params);
    }
}

