/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.documents;

import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoogleSpreadsheetsRenderer
implements WidgetRenderer {
    private static final Pattern PATTERN = Pattern.compile("key=([^&]+)");
    private static final String VELOCITY_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/iframe.vm";
    private static final String DEFAULT_WIDTH = "720px";
    private static final String DEFAULT_HEIGHT = "360px";
    private VelocityRenderService velocityRenderService;
    private static final String[] MATCH_URLs = new String[]{"docs.google.com/.*spreadsheet", "spreadsheets.google.com"};
    private static final String WIDGET_PARAM = "widget=";
    private static final String ELEMENT_PARAM = "element=";
    private static final String OUTPUT_PARAM = "output=";

    public GoogleSpreadsheetsRenderer(VelocityRenderService velocityRenderService) {
        this.velocityRenderService = velocityRenderService;
    }

    public String getEmbedUrl(String url) {
        String embeddedUrl = this.matchWithOldSpreadsheetUrl(url);
        if (embeddedUrl == null) {
            embeddedUrl = this.matchWithNewSpreadsheetUrl(url);
        }
        return embeddedUrl;
    }

    @Override
    public boolean matches(String url) {
        for (String matchUrl : MATCH_URLs) {
            Pattern pattern = Pattern.compile(matchUrl);
            Matcher matcher = pattern.matcher(url);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        if (!params.containsKey("width")) {
            params.put("width", DEFAULT_WIDTH);
        }
        if (!params.containsKey("height")) {
            params.put("height", DEFAULT_HEIGHT);
        }
        params.put("_template", VELOCITY_TEMPLATE);
        return this.velocityRenderService.render(this.getEmbedUrl(url), params);
    }

    private String matchWithOldSpreadsheetUrl(String url) {
        StringBuilder embeddedUrl = new StringBuilder("//docs.google.com/spreadsheet/pub?");
        Matcher m = PATTERN.matcher(url);
        if (!m.find()) {
            return null;
        }
        String key = m.group(1);
        embeddedUrl.append("key=").append(key);
        embeddedUrl.append("&output=html&widget=true&element=true&gid=0");
        return embeddedUrl.toString();
    }

    private String matchWithNewSpreadsheetUrl(String url) {
        if (url == null || !url.endsWith("/pubhtml")) {
            return null;
        }
        return url + "?widget=true&headers=false&chrome=false";
    }
}

