/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.chatter;

import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.HttpRetrievalService;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.VCacheException;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterRenderer
implements WidgetRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(TwitterRenderer.class);
    private static final String CACHE_NAME = TwitterRenderer.class.getName();
    private static final long SINGLE_TWEET_RETRIEVAL_FAILURE_DELAY = Long.getLong("com.atlassian.confluence.extra.widgetconnector.chatter.TwitterRenderer.singletweet.failure.delay", 60000L);
    private static final Pattern SINGLE_TWEET_PATTERN = Pattern.compile("^(https?)://twitter\\.com/(.*?)/status(es)??/(\\d+)+/?$");
    private static final Pattern WIDGET_PATTERN = Pattern.compile("(https?)://twitter\\.com/settings/widgets/(\\d+).*$");
    private static final String VELOCITY_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/twitter.vm";
    private static final String SINGLE_TWEET_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/tweet.vm";
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;
    private final PageBuilderService pageBuilderService;
    private final VelocityRenderService velocityRenderService;
    private final HttpRetrievalService httpRetrievalService;
    private final Supplier<StableReadExternalCache<TweetRetrievalResult>> cacheRef;

    public TwitterRenderer(I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, VCacheFactory cacheFactory, PageBuilderService pageBuilderService, VelocityRenderService velocityRenderService, HttpRetrievalService httpRetrievalService) {
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.pageBuilderService = pageBuilderService;
        this.velocityRenderService = velocityRenderService;
        this.httpRetrievalService = httpRetrievalService;
        this.cacheRef = Lazy.supplier(() -> cacheFactory.getStableReadExternalCache(CACHE_NAME, MarshallerFactory.serializableMarshaller(TweetRetrievalResult.class), new ExternalCacheSettingsBuilder().build()));
    }

    public Map<String, String> getParameters(String url, Map<String, String> params) {
        Matcher singleTweetMatcher = SINGLE_TWEET_PATTERN.matcher(url);
        if (singleTweetMatcher.matches()) {
            this.populateDefaultDimensionParams(params);
            params.put("_template", SINGLE_TWEET_TEMPLATE);
            params.put("tweetHtml", this.getTweetHtml(singleTweetMatcher.group(1), singleTweetMatcher.group(2), singleTweetMatcher.group(4)));
        } else {
            Matcher widgetMatcher = WIDGET_PATTERN.matcher(url);
            if (widgetMatcher.matches()) {
                this.populateDefaultDimensionParams(params);
                params.put("widgetId", widgetMatcher.group(2));
                params.put("_template", VELOCITY_TEMPLATE);
            }
        }
        return params;
    }

    private void populateDefaultDimensionParams(Map<String, String> params) {
        if (!params.containsKey("width")) {
            params.put("width", String.valueOf(-1));
        }
        if (!params.containsKey("height")) {
            params.put("height", String.valueOf(-1));
        }
    }

    private String getTweetHtml(String protocol, String twitterUserName, String statusId) {
        TweetRetrievalResult tweetRetrievalResult = this.getTweetRetrievalResultFromCache(statusId, (Supplier<TweetRetrievalResult>)((Supplier)() -> this.getTweetHtmlFromTwitter(protocol, statusId)));
        if (tweetRetrievalResult.successful) {
            return tweetRetrievalResult.tweetMarkup;
        }
        if (tweetRetrievalResult.isExpiredFailureResult()) {
            return this.getTweetHtml(protocol, twitterUserName, statusId);
        }
        return this.getErrorMessageMarkup(protocol, twitterUserName, statusId);
    }

    private String getErrorMessageMarkup(String protocol, String twitterUserName, String statusId) {
        return RenderUtils.blockError((String)this.getText("com.atlassian.confluence.extra.widgetconnector.twitter.single.error", protocol + String.format("://twitter.com/%s/status/%s", twitterUserName, statusId), SINGLE_TWEET_RETRIEVAL_FAILURE_DELAY / 60000L), (String)"");
    }

    @Nonnull
    private TweetRetrievalResult getTweetRetrievalResultFromCache(String statusId, Supplier<TweetRetrievalResult> loader) {
        try {
            TweetRetrievalResult result = (TweetRetrievalResult)VCacheUtils.join((CompletionStage)((StableReadExternalCache)this.cacheRef.get()).get(statusId, () -> loader.get()));
            if (result.isExpiredFailureResult()) {
                this.removeFromCache(statusId);
            }
            return result;
        }
        catch (VCacheException | ClassCastException pluginUpgraded) {
            LOG.debug("Removed cached Tweet retrieval result by a previously installed version of the Widget Connector Plugin.", pluginUpgraded);
            this.removeFromCache(statusId);
            return (TweetRetrievalResult)loader.get();
        }
    }

    private Void removeFromCache(String statusId) {
        return (Void)VCacheUtils.join((CompletionStage)((StableReadExternalCache)this.cacheRef.get()).remove(new String[]{statusId}));
    }

    private String getText(String key, Object ... substitutions) {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale(AuthenticatedUserThreadLocal.getUser())).getText(key, substitutions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TweetRetrievalResult getTweetHtmlFromTwitter(String protocol, String statusId) {
        try {
            HttpResponse response = this.httpRetrievalService.get(String.format("%s://api.twitter.com/1/statuses/oembed.json?id=%s&omit_script=true&lang=%s", protocol, statusId, GeneralUtil.urlEncode((String)this.localeManager.getLocale(AuthenticatedUserThreadLocal.getUser()).getLanguage())));
            if (response.isFailed()) return this.newFailureResult(response.getStatusMessage());
            if (response.isNotFound()) return this.newFailureResult(response.getStatusMessage());
            if (response.isNotPermitted()) return this.newFailureResult(response.getStatusMessage());
            try (InputStream jsonInput = response.getResponse();){
                TweetRetrievalResult tweetRetrievalResult = this.newSuccessfulResult(new JSONObject(IOUtils.toString((InputStream)jsonInput, (String)"UTF-8")).getString("html"));
                return tweetRetrievalResult;
            }
        }
        catch (JSONException invalidResponse) {
            LOG.error("Invalid JSON returned by Twitter", (Throwable)invalidResponse);
            return this.newFailureResult(invalidResponse.getMessage());
        }
        catch (IOException retrieveTweetError) {
            LOG.error("Unable to read response from Twitter", (Throwable)retrieveTweetError);
            return this.newFailureResult(retrieveTweetError.getMessage());
        }
    }

    private TweetRetrievalResult newFailureResult(String failureMessage) {
        return new TweetRetrievalResult(false, System.currentTimeMillis(), null, failureMessage);
    }

    private TweetRetrievalResult newSuccessfulResult(String tweetMarkup) {
        return new TweetRetrievalResult(true, System.currentTimeMillis(), tweetMarkup, null);
    }

    @Override
    public boolean matches(String url) {
        return SINGLE_TWEET_PATTERN.matcher(url).matches() || WIDGET_PATTERN.matcher(url).matches();
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.confluence.extra.widgetconnector:twitter-webresources");
        return this.velocityRenderService.render(url, this.getParameters(url, params));
    }

    static class TweetRetrievalResult
    implements Serializable {
        private final boolean successful;
        private final long timestamp;
        private final String tweetMarkup;
        private final String errorMessage;

        TweetRetrievalResult() {
            this(false, 0L, null, null);
        }

        TweetRetrievalResult(boolean successful, long timestamp, String tweetMarkup, String errorMessage) {
            this.successful = successful;
            this.timestamp = timestamp;
            this.tweetMarkup = tweetMarkup;
            this.errorMessage = errorMessage;
        }

        public boolean isExpiredFailureResult() {
            return !this.successful && System.currentTimeMillis() - this.timestamp > SINGLE_TWEET_RETRIEVAL_FAILURE_DELAY;
        }
    }
}

