/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector;

import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.pages.thumbnail.Dimensions;
import com.atlassian.confluence.util.GeneralUtil;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetConnectorUtil {
    private static final Logger log = LoggerFactory.getLogger(WidgetConnectorUtil.class);

    public static String cleanupUrl(String url) {
        if (url.indexOf(40) > 0) {
            url = url.replaceAll("\\(", "%28");
        }
        if (url.indexOf(41) > 0) {
            url = url.replaceAll("\\)", "%29");
        }
        if (url.indexOf("&amp;") > 0) {
            url = url.replaceAll("&amp;", "&");
        }
        return GeneralUtil.htmlEncode((String)url);
    }

    public static ImagePlaceholder generateDefaultImagePlaceholder(String baseUrl) {
        if (baseUrl == null || baseUrl.isEmpty()) {
            baseUrl = "Widget Connector";
        }
        Dimensions dimension = new Dimensions(300, 225);
        String command = String.format("%s?%s=%s&%s=%d&%s=%d", "/plugins/servlet/widgetconnector/placeholder", "thumb", baseUrl, "width", dimension.getWidth(), "height", dimension.getHeight());
        return new DefaultImagePlaceholder(command, dimension, true);
    }

    public static boolean isURLMatch(String url, String matchUrl) {
        try {
            String host = new URI(url).getHost();
            return host != null && !host.isEmpty() ? url.contains(matchUrl) : false;
        }
        catch (URISyntaxException e) {
            log.error("Invalid URL [" + url + "] provided - " + e.getMessage());
            return false;
        }
    }
}

