/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector;

import com.atlassian.confluence.extra.widgetconnector.RenderManager;
import com.atlassian.confluence.extra.widgetconnector.WidgetConnectorUtil;
import com.atlassian.confluence.extra.widgetconnector.WidgetImagePlaceholder;
import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DefaultRenderManager
implements RenderManager {
    private List<WidgetRenderer> renderSupporter;
    public static final String ERROR_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/error.vm";
    public static final Pattern BASEURL_PATTERN = Pattern.compile("^https?://([^/]++)(?:/.*)?");

    public DefaultRenderManager(List<WidgetRenderer> renderSupporter) {
        this.renderSupporter = renderSupporter;
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        for (WidgetRenderer widgetRenderer : this.renderSupporter) {
            String embedHtml;
            if (!widgetRenderer.matches(url) || !StringUtils.isNotEmpty((String)(embedHtml = widgetRenderer.getEmbeddedHtml(url, params)))) continue;
            return embedHtml;
        }
        Map<String, Object> contextMap = this.getDefaultVelocityContext();
        contextMap.put("urlHtml", GeneralUtil.htmlEncode((String)url));
        contextMap.put("baseUrlHtml", GeneralUtil.htmlEncode((String)this.getBaseUrl(url)));
        return this.getRenderedTemplate(contextMap);
    }

    @Override
    public ImagePlaceholder getImagePlaceholder(String url, Map<String, String> params) {
        for (WidgetRenderer widgetRenderer : this.renderSupporter) {
            if (!widgetRenderer.matches(url)) continue;
            if (!(widgetRenderer instanceof WidgetImagePlaceholder)) break;
            ImagePlaceholder placeholder = ((WidgetImagePlaceholder)((Object)widgetRenderer)).getImagePlaceholder(url, params);
            if (placeholder == null) continue;
            return placeholder;
        }
        return WidgetConnectorUtil.generateDefaultImagePlaceholder(this.getBaseUrl(url));
    }

    @Override
    public String getBaseUrl(String url) {
        Matcher m = BASEURL_PATTERN.matcher(url);
        if (m.find()) {
            return m.group(1);
        }
        return url;
    }

    protected Map<String, Object> getDefaultVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }

    protected String getRenderedTemplate(Map<String, Object> contextMap) {
        return VelocityUtils.getRenderedTemplate((String)ERROR_TEMPLATE, contextMap);
    }
}

