/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.query;

import com.atlassian.confluence.spaces.Space;
import java.util.Collection;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;

public class UsageQuery {
    private String period = "daily";
    private Collection contentTypes;
    private Collection spaces;
    private Collection eventTypes;
    private String columns;
    private Date[] timespan;

    public UsageQuery() {
    }

    public UsageQuery(UsageQuery q) {
        this.period = q.getPeriod();
        this.contentTypes = q.getContentTypes();
        this.spaces = q.getSpaces();
        this.eventTypes = q.getEventTypes();
        this.columns = q.getColumns();
        this.timespan = q.getTimespan();
    }

    private Date[] getTimespan() {
        return this.timespan;
    }

    public Query getLuceneQuery() {
        BooleanQuery q = new BooleanQuery();
        if (!this.contentTypes.isEmpty()) {
            BooleanQuery typesQuery = new BooleanQuery();
            for (String contentType : this.contentTypes) {
                typesQuery.add((Query)new TermQuery(new Term("entityType", contentType)), BooleanClause.Occur.SHOULD);
            }
            q.add((Query)typesQuery, BooleanClause.Occur.MUST);
        }
        if (!this.eventTypes.isEmpty()) {
            BooleanQuery eventsQuery = new BooleanQuery();
            for (String eventType : this.eventTypes) {
                eventsQuery.add((Query)new TermQuery(new Term("eventType", eventType)), BooleanClause.Occur.SHOULD);
            }
            q.add((Query)eventsQuery, BooleanClause.Occur.MUST);
        }
        if (!this.spaces.isEmpty()) {
            BooleanQuery spacesQuery = new BooleanQuery();
            for (Space space : this.spaces) {
                spacesQuery.add((Query)new TermQuery(new Term("space", Long.toString(space.getId()))), BooleanClause.Occur.SHOULD);
            }
            q.add((Query)spacesQuery, BooleanClause.Occur.MUST);
        }
        if (this.timespan != null && this.timespan.length == 2 && (this.timespan[0] != null || this.timespan[1] != null)) {
            Date lower = null;
            Date upper = null;
            if (this.timespan[0] != null) {
                lower = this.timespan[0];
            }
            if (this.timespan.length > 0 && this.timespan[1] != null) {
                upper = this.timespan[1];
            }
            q.add((Query)new TermRangeQuery("date", lower != null ? new BytesRef((CharSequence)DateTools.dateToString((Date)lower, (DateTools.Resolution)DateTools.Resolution.SECOND)) : null, upper != null ? new BytesRef((CharSequence)DateTools.dateToString((Date)upper, (DateTools.Resolution)DateTools.Resolution.SECOND)) : null, true, true), BooleanClause.Occur.MUST);
        }
        if (q.getClauses().length == 0) {
            return new MatchAllDocsQuery();
        }
        return q;
    }

    public String getPeriod() {
        return this.period;
    }

    public Collection getContentTypes() {
        return this.contentTypes;
    }

    public Collection getSpaces() {
        return this.spaces;
    }

    public Collection getEventTypes() {
        return this.eventTypes;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public void setContentTypes(Collection types) {
        this.contentTypes = types;
    }

    public void setSpaces(Collection spaces) {
        this.spaces = spaces;
    }

    public void setEventTypes(Collection events) {
        this.eventTypes = events;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public void setTimespan(Date[] timespan) {
        this.timespan = timespan;
    }
}

