/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.query;

import java.util.Date;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;

public class UsageDataUtils {
    public static RegularTimePeriod getTimePeriod(String periodName, Date date) {
        return RegularTimePeriod.createInstance(UsageDataUtils.getTimePeriodClass(periodName), date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public static Class getTimePeriodClass(String periodName) {
        if (periodName.equalsIgnoreCase("daily")) {
            return Day.class;
        }
        if (periodName.equalsIgnoreCase("minutely")) {
            return Minute.class;
        }
        if (periodName.equalsIgnoreCase("hourly")) {
            return Hour.class;
        }
        if (periodName.equalsIgnoreCase("weekly")) {
            return Week.class;
        }
        if (periodName.equalsIgnoreCase("monthly")) {
            return Month.class;
        }
        if (periodName.equalsIgnoreCase("quarterly")) {
            return Quarter.class;
        }
        if (periodName.equalsIgnoreCase("yearly")) {
            return Year.class;
        }
        return Day.class;
    }

    public static TimeSeriesCollection makeCumulative(TimeSeriesCollection collection) {
        TimeSeriesCollection result = new TimeSeriesCollection();
        for (int i = 0; i < collection.getSeriesCount(); ++i) {
            TimeSeries oldSeries = collection.getSeries(i);
            TimeSeries cumulativeSeries = new TimeSeries((Comparable)((Object)((String)((Object)oldSeries.getKey()))), oldSeries.getTimePeriodClass());
            int cumulativeValue = 0;
            for (int j = 0; j < oldSeries.getItemCount(); ++j) {
                cumulativeSeries.add(oldSeries.getTimePeriod(j), new Integer(cumulativeValue += oldSeries.getValue(j).intValue()));
            }
            result.addSeries(cumulativeSeries);
        }
        return result;
    }

    public static void normaliseDateRange(TimeSeriesCollection collection, RegularTimePeriod[] range) {
        if (collection.getSeriesCount() == 0) {
            return;
        }
        RegularTimePeriod earliest = range[0];
        RegularTimePeriod latest = range[1];
        RegularTimePeriod cursor = earliest;
        for (int i = 0; i < collection.getSeriesCount(); ++i) {
            TimeSeries series = collection.getSeries(i);
            while (cursor.compareTo(latest) != 1) {
                if (series.getValue(cursor) == null) {
                    series.add(cursor, new Integer(0));
                }
                cursor = cursor.next();
            }
            cursor = earliest;
        }
    }
}

