/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.query;

import com.atlassian.confluence.ext.usage.query.AbstractUsageQuery;
import com.atlassian.confluence.labels.Label;
import java.util.Collection;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ContentUsageQuery
extends AbstractUsageQuery {
    private Collection<String> contentTypes;
    protected Collection<Label> labels;

    public ContentUsageQuery() {
    }

    public ContentUsageQuery(ContentUsageQuery q) {
        this.period = q.getPeriod();
        this.contentTypes = q.getContentTypes();
        this.spaces = q.getSpaces();
        this.labels = q.getLabels();
        this.eventTypes = q.getEventTypes();
        this.columns = q.getColumns();
        this.timespan = q.getTimespan();
    }

    @Override
    protected void addBooleanClauses(BooleanQuery query) {
        if (!this.contentTypes.isEmpty()) {
            BooleanQuery typesQuery = new BooleanQuery();
            for (String contentType : this.contentTypes) {
                typesQuery.add((Query)new TermQuery(new Term("entityType", contentType)), BooleanClause.Occur.SHOULD);
            }
            query.add((Query)typesQuery, BooleanClause.Occur.MUST);
        }
    }

    public Collection<String> getContentTypes() {
        return this.contentTypes;
    }

    public void setContentTypes(Collection<String> types) {
        this.contentTypes = types;
    }

    public Collection<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(Collection<Label> labels) {
        this.labels = labels;
    }
}

