/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.ext.usage.index.UsageIndexManager;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class AbstractUsageMacro
extends BaseMacro
implements Macro {
    UsageIndexManager usageIndexManager;
    SpaceManager spaceManager;
    LabelManager labelManager;
    DateFormat timespanDF = new SimpleDateFormat("dd/MM/yy");
    public static final String TIMESPAN_FORMAT_STRING = "dd/MM/yy";

    public void setUsageIndexManager(UsageIndexManager usageIndexManager) {
        this.usageIndexManager = usageIndexManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    protected String getEitherParameter(Map parameters, String param1, String param2) {
        String paramValue = (String)parameters.get(param1);
        if (paramValue == null) {
            paramValue = (String)parameters.get(param2);
        }
        return paramValue;
    }

    protected boolean hasEitherParameter(Map parameters, String param1, String param2) {
        return parameters.containsKey(param1) || parameters.containsKey(param2);
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public Space getSpace(String id) {
        return this.spaceManager.getSpace(Long.parseLong(id));
    }

    public String makeTitleCase(String s) {
        if (s.length() > 0) {
            return Character.toTitleCase(s.charAt(0)) + s.substring(1);
        }
        return s;
    }

    protected String calculateColumns(Map parameters) {
        if (parameters.containsKey("columns")) {
            String c = (String)parameters.get("columns");
            if (c == null) {
                return null;
            }
            if ((c = c.toLowerCase()).startsWith("event")) {
                return "event";
            }
            if (c.startsWith("space")) {
                return "space";
            }
            if (c.startsWith("type")) {
                return "type";
            }
        }
        return null;
    }

    protected Date[] calculateTimeSpan(Map parameters) {
        return this.calculateTimeSpan(parameters, "1d");
    }

    protected Date[] calculateTimeSpan(Map parameters, String defaultTimespan) {
        String timespanParam = (String)parameters.get("timespan");
        if (timespanParam == null) {
            timespanParam = defaultTimespan;
        }
        Date[] timespan = new Date[]{null, null};
        String after = null;
        String before = null;
        int seperatorIdx = timespanParam.indexOf(",");
        if (seperatorIdx < 0) {
            after = timespanParam.trim();
            timespan[1] = new Date();
        } else {
            after = timespanParam.substring(0, seperatorIdx);
            before = timespanParam.substring(seperatorIdx + 1).trim();
        }
        if (after != null) {
            timespan[0] = this.parseDate(after);
        }
        if (before != null) {
            timespan[1] = this.parseDate(before);
        }
        return timespan;
    }

    private Date parseDate(String span) {
        try {
            long time = DateUtils.getDuration((String)span) * DateUtils.SECOND_MILLIS;
            return new Date(System.currentTimeMillis() - time);
        }
        catch (InvalidDurationException e) {
            try {
                return this.timespanDF.parse(span);
            }
            catch (ParseException e1) {
                return null;
            }
        }
    }

    protected Collection calculateEvents(Map parameters) {
        HashSet<String> events = new HashSet<String>();
        if (this.hasEitherParameter(parameters, "event", "events")) {
            String eventsParam = this.getEitherParameter(parameters, "event", "events");
            StringTokenizer stringTokenizer = new StringTokenizer(eventsParam, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String s = stringTokenizer.nextToken().toLowerCase();
                if (s.startsWith("view")) {
                    events.add("view");
                    continue;
                }
                if (s.startsWith("create")) {
                    events.add("create");
                    continue;
                }
                if (s.startsWith("update") || s.startsWith("edit")) {
                    events.add("update");
                    continue;
                }
                if (s.startsWith("remove")) {
                    events.add("remove");
                    continue;
                }
                if (!s.equalsIgnoreCase("all") && !s.equalsIgnoreCase("@all")) continue;
                return Collections.EMPTY_SET;
            }
        } else {
            events.add("view");
        }
        return events;
    }

    protected Collection calculateTypes(Map parameters) {
        HashSet<String> types = new HashSet<String>();
        if (this.hasEitherParameter(parameters, "type", "types")) {
            String typesParam = this.getEitherParameter(parameters, "type", "types");
            StringTokenizer stringTokenizer = new StringTokenizer(typesParam, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String s = stringTokenizer.nextToken().toLowerCase();
                if (s.startsWith("page")) {
                    types.add("page");
                    continue;
                }
                if (s.startsWith("comment")) {
                    types.add("comment");
                    continue;
                }
                if (s.startsWith("blogpost")) {
                    types.add("blogpost");
                    continue;
                }
                if (s.startsWith("news")) {
                    types.add("blogpost");
                    continue;
                }
                if (s.startsWith("space")) {
                    types.add("space");
                    continue;
                }
                if (!s.equalsIgnoreCase("all") && !s.equalsIgnoreCase("@all")) continue;
                return Collections.EMPTY_SET;
            }
        } else {
            types.add("page");
        }
        return types;
    }

    protected Collection calculateSpaces(Map parameters, ConversionContext conversionContext) {
        HashSet<Space> spaces = new HashSet<Space>();
        if (this.hasEitherParameter(parameters, "space", "spaces")) {
            String spacesParam = this.getEitherParameter(parameters, "space", "spaces");
            StringTokenizer stringTokenizer = new StringTokenizer(spacesParam, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String s = stringTokenizer.nextToken();
                Space space = this.spaceManager.getSpace(s);
                if (space != null) {
                    spaces.add(space);
                    continue;
                }
                if (!s.equalsIgnoreCase("all") && !s.equalsIgnoreCase("@all")) continue;
                return Collections.EMPTY_SET;
            }
        } else {
            PageContext pageContext = conversionContext.getPageContext();
            Space space = null;
            if (pageContext != null) {
                space = this.spaceManager.getSpace(pageContext.getSpaceKey());
            }
            if (space != null) {
                spaces.add(space);
            }
        }
        return spaces;
    }

    protected Collection calculateLabels(Map parameters, ConversionContext conversionContext) {
        HashSet<Label> labels = new HashSet<Label>();
        if (this.hasEitherParameter(parameters, "label", "labels")) {
            String labelsParam = this.getEitherParameter(parameters, "label", "labels");
            StringTokenizer stringTokenizer = new StringTokenizer(labelsParam, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String s = stringTokenizer.nextToken();
                Label label = this.labelManager.getLabel(s);
                if (label != null) {
                    labels.add(label);
                    continue;
                }
                labels.add(new Label(s));
            }
        }
        return labels;
    }

    protected String calculatePeriod(Map parameters) {
        String period = "daily";
        if (parameters.containsKey("period")) {
            String periodParam = (String)parameters.get("period");
            if ("daily".equalsIgnoreCase(periodParam) || "day".equalsIgnoreCase(periodParam) || "d".equals(periodParam)) {
                period = "daily";
            } else if ("weekly".equalsIgnoreCase(periodParam) || "week".equalsIgnoreCase(periodParam) || "w".equals(periodParam)) {
                period = "weekly";
            } else if ("monthly".equalsIgnoreCase(periodParam) || "month".equalsIgnoreCase(periodParam) || "M".equals(periodParam)) {
                period = "monthly";
            } else if ("hourly".equalsIgnoreCase(periodParam) || "hour".equalsIgnoreCase(periodParam) || "h".equals(periodParam)) {
                period = "hourly";
            } else if ("minutely".equalsIgnoreCase(periodParam) || "minute".equalsIgnoreCase(periodParam) || "m".equals(periodParam)) {
                period = "minutely";
            } else if ("yearly".equalsIgnoreCase(periodParam) || "year".equalsIgnoreCase(periodParam) || "y".equals(periodParam)) {
                period = "yearly";
            } else if ("minutely".equalsIgnoreCase(periodParam) || "quarter".equalsIgnoreCase(periodParam) || "q".equals(periodParam)) {
                period = "quarterly";
            }
        }
        return period;
    }

    protected int calculateMax(Map parameters, int defaultMax) {
        return this.getIntParameter("max", parameters, defaultMax);
    }

    protected int getIntParameter(String paramName, Map parameters, int defaultValue) {
        if (parameters.containsKey(paramName)) {
            String paramValueStr = (String)parameters.get(paramName);
            try {
                return Integer.parseInt(paramValueStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected String getStringParameter(String paramName, Map parameters, String defaultValue) {
        if (parameters.containsKey(paramName)) {
            return ((String)parameters.get(paramName)).trim();
        }
        return defaultValue;
    }

    protected Collection getDelimitedStringParameter(String paramName, Map parameters, List defaultValue) {
        if (parameters.containsKey(paramName)) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer((String)parameters.get(paramName), ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String s = stringTokenizer.nextToken();
                result.add(s);
            }
            return result;
        }
        return defaultValue;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) {
        return this.execute((Map<String, String>)parameters, body, (ConversionContext)new DefaultConversionContext(renderContext));
    }

    public abstract String execute(Map<String, String> var1, String var2, ConversionContext var3);
}

