/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.index;

import com.atlassian.bonnie.BonnieConstants;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.ext.usage.event.UsageEventWrapperTask;
import com.atlassian.confluence.ext.usage.index.PopularResult;
import com.atlassian.confluence.ext.usage.index.UserResult;
import com.atlassian.confluence.ext.usage.query.ContentUsageQuery;
import com.atlassian.confluence.ext.usage.query.TopUserQuery;
import com.atlassian.confluence.ext.usage.query.UsageDataUtils;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.search.lucene.filter.ContentPermissionsFilter;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class UsageIndexManager
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UsageIndexManager.class);
    private static final int OPTIMIZATION_FREQUENCY = 1000;
    private ILuceneConnection connection;
    private int optimizeCounter = 0;
    private SpaceManager spaceManager;
    private SpacePermissionManager spacePermissionManager;
    private BootstrapManager bootstrapManager;
    private ContentEntityManager contentEntityManager;
    private UserAccessor userAccessor;
    private PermissionManager permissionManager;

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setUserAccessor(UserAccessor userManager) {
        this.userAccessor = userManager;
    }

    public void afterPropertiesSet() {
        String indexDir = this.bootstrapManager.getFilePathProperty("lucene.index.dir") + File.separator + "plugin" + File.separator + "usage";
        File f = new File(indexDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        this.connection = new LuceneConnection(f, (Analyzer)new StandardAnalyzer(BonnieConstants.LUCENE_VERSION));
    }

    public void destroy() {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public TimeSeriesCollection queryUsage(final ContentUsageQuery q) {
        final TimeSeriesCollection dataset = new TimeSeriesCollection();
        final RegularTimePeriod[] range = new RegularTimePeriod[]{null, null};
        UtilTimerStack.push((String)"UsageIndexManager::queryUsage");
        User user = AuthenticatedUserThreadLocal.getUser();
        if (this.filterSpacesForUser(q.getSpaces(), user) != 0 && q.getSpaces().isEmpty()) {
            return dataset;
        }
        if (this.connection != null) {
            this.connection.withSearch(new ILuceneConnection.SearcherAction(){

                public void perform(IndexSearcher searcher) throws IOException {
                    searcher.search(q.getLuceneQuery(), new Collector(){
                        private AtomicReaderContext context;

                        public void collect(int docId) throws IOException {
                            try {
                                Document d = this.context.reader().document(docId);
                                this.collectResult(dataset, d, q);
                            }
                            catch (IOException e) {
                                log.error("IO error", (Throwable)e);
                            }
                            catch (ParseException e) {
                                log.error("Parse error", (Throwable)e);
                            }
                        }

                        private void collectResult(TimeSeriesCollection collection, Document document, ContentUsageQuery q) throws ParseException {
                            Number value;
                            TimeSeries series;
                            Date date = DateTools.stringToDate((String)document.get("date"));
                            RegularTimePeriod timePeriod = UsageDataUtils.getTimePeriod(q.getPeriod(), date);
                            String column = "Events";
                            if (q.getColumns() != null) {
                                if ("event".equals(q.getColumns())) {
                                    column = document.get("eventType");
                                } else if ("space".equals(q.getColumns())) {
                                    column = document.get("space");
                                } else if ("type".equals(q.getColumns())) {
                                    column = document.get("entityType");
                                }
                            }
                            if ((series = collection.getSeries((Comparable)((Object)column))) == null) {
                                series = new TimeSeries((Comparable)((Object)column), UsageDataUtils.getTimePeriodClass(q.getPeriod()));
                                collection.addSeries(series);
                            }
                            if ((value = series.getValue(timePeriod)) == null) {
                                series.add(timePeriod, new Integer(1));
                            } else {
                                series.update(timePeriod, (Number)new Integer(1 + value.intValue()));
                            }
                            if (range[0] == null || timePeriod.compareTo(range[0]) < 0) {
                                range[0] = timePeriod;
                            }
                            if (range[1] == null || timePeriod.compareTo(range[1]) > 0) {
                                range[1] = timePeriod;
                            }
                        }

                        public void setNextReader(AtomicReaderContext context) throws IOException {
                            this.context = context;
                        }

                        public boolean acceptsDocsOutOfOrder() {
                            return false;
                        }

                        public void setScorer(Scorer scorer) throws IOException {
                        }
                    });
                }
            });
        }
        UsageDataUtils.normaliseDateRange(dataset, range);
        UtilTimerStack.pop((String)"UsageIndexManager::queryUsage");
        return dataset;
    }

    protected int filterSpacesForUser(Collection spaces, User user) {
        int filterCount = 0;
        Iterator iter = spaces.iterator();
        while (iter.hasNext()) {
            Space space = (Space)iter.next();
            if (this.hasViewSpacePermission(space, user)) continue;
            iter.remove();
            ++filterCount;
        }
        return filterCount;
    }

    public void index(final UsageEventWrapperTask task) {
        if (task == null) {
            return;
        }
        if (this.connection != null) {
            this.connection.withWriter(new ILuceneConnection.WriterAction(){

                public void perform(IndexWriter indexWriter) throws IOException {
                    if (log.isDebugEnabled()) {
                        log.debug("Indexing: " + task);
                    }
                    indexWriter.addDocument((Iterable)task.getDocument());
                }
            });
            --this.optimizeCounter;
            if (this.optimizeCounter <= 0) {
                this.optimizeCounter = 1000;
                this.connection.optimize();
            }
        }
    }

    public List<PopularResult> queryPopular(ContentUsageQuery q, int max) {
        List<PopularResult> results = new LinkedList<PopularResult>();
        UtilTimerStack.push((String)"UsageIndexManager::queryPopular");
        if (this.connection != null) {
            ContentUsageQuery queryToRun;
            boolean spaceQuery;
            final HashMap unorderedResults = new HashMap();
            if (q.getContentTypes().contains("space")) {
                spaceQuery = true;
                queryToRun = new ContentUsageQuery(q);
                queryToRun.setContentTypes(Collections.emptyList());
            } else {
                spaceQuery = false;
                queryToRun = q;
            }
            final User user = AuthenticatedUserThreadLocal.getUser();
            final List groupNames = this.userAccessor.getGroupNames(user);
            this.connection.withSearch(new ILuceneConnection.SearcherAction(){

                public void perform(IndexSearcher searcher) throws IOException {
                    searcher.search(queryToRun.getLuceneQuery(), (Filter)new ContentPermissionsFilter(user, (Iterable)groupNames), new Collector(){
                        private AtomicReaderContext context;

                        public void collect(int docId) throws IOException {
                            String entityType;
                            String entityId;
                            Document d = this.context.reader().document(docId);
                            if (spaceQuery) {
                                entityId = d.get("space");
                                entityType = "space";
                            } else {
                                entityId = d.get("entity");
                                entityType = d.get("entityType");
                            }
                            PopularResult cr = (PopularResult)unorderedResults.get(entityId);
                            if (cr == null) {
                                cr = new PopularResult(UsageIndexManager.this.spaceManager, UsageIndexManager.this.contentEntityManager, entityId, entityType);
                            }
                            if (cr.getSpace() == null && cr.getContent() == null) {
                                return;
                            }
                            cr.incrementCount();
                            unorderedResults.put(entityId, cr);
                        }

                        public void setNextReader(AtomicReaderContext context) throws IOException {
                            this.context = context;
                        }

                        public void setScorer(Scorer scorer) throws IOException {
                        }

                        public boolean acceptsDocsOutOfOrder() {
                            return false;
                        }
                    });
                }
            });
            Collection<PopularResult> filteredResults = this.filterPopularResults(unorderedResults.values(), user);
            if (!queryToRun.getLabels().isEmpty()) {
                filteredResults = this.filterPopularResultsByLabels(filteredResults, queryToRun.getLabels());
            }
            results.addAll(filteredResults);
            Collections.sort(results);
            if (results.size() > max) {
                results = results.subList(0, max);
            }
        }
        UtilTimerStack.pop((String)"UsageIndexManager::queryPopular");
        return results;
    }

    protected Collection<PopularResult> filterPopularResults(Collection<PopularResult> results, User user) {
        LinkedList<PopularResult> filteredResults = new LinkedList<PopularResult>();
        for (PopularResult result : results) {
            if (!this.hasPermissionForResult(result, user)) continue;
            filteredResults.add(result);
        }
        return filteredResults;
    }

    protected Collection<PopularResult> filterPopularResultsByLabels(Collection<PopularResult> results, Collection<Label> labels) {
        LinkedList<PopularResult> filteredResults = new LinkedList<PopularResult>();
        for (PopularResult result : results) {
            if (!result.getLabels().containsAll(labels)) continue;
            filteredResults.add(result);
        }
        return filteredResults;
    }

    public List<UserResult> queryTopUsers(final TopUserQuery q, int max) {
        ArrayList<UserResult> results = new ArrayList<UserResult>();
        if (this.connection != null) {
            final HashMap unorderedResults = new HashMap();
            this.connection.withSearch(new ILuceneConnection.SearcherAction(){

                public void perform(IndexSearcher searcher) throws IOException {
                    searcher.search(q.getLuceneQuery(), new Collector(){
                        private AtomicReaderContext context;

                        public void collect(int docId) throws IOException {
                            Document d = this.context.reader().document(docId);
                            String entityId = d.get("user");
                            UserResult cr = (UserResult)unorderedResults.get(entityId);
                            if (cr == null) {
                                cr = new UserResult(entityId, UsageIndexManager.this.userAccessor);
                                unorderedResults.put(entityId, cr);
                            }
                            cr.incrementCount();
                        }

                        public void setNextReader(AtomicReaderContext context) throws IOException {
                            this.context = context;
                        }

                        public boolean acceptsDocsOutOfOrder() {
                            return false;
                        }

                        public void setScorer(Scorer scorer) throws IOException {
                        }
                    });
                }
            });
            results.addAll(unorderedResults.values());
            Collections.sort(results);
            if (results.size() > max) {
                return results.subList(0, max);
            }
        }
        return results;
    }

    protected boolean hasViewSpacePermission(Space space, User user) {
        return this.spacePermissionManager.hasPermission("VIEWSPACE", space, user);
    }

    protected boolean hasPermissionForResult(PopularResult result, User user) {
        if ("space".equalsIgnoreCase(result.getEntityType())) {
            return this.hasViewSpacePermission(result.getSpace(), user);
        }
        return this.permissionManager.hasPermission(user, Permission.VIEW, (Object)result.getContent());
    }

    protected boolean hasViewPermissionInIndex(Document document, User user) {
        String userPermission = document.get("userpermission");
        String[] groupPermissions = document.getValues("grouppermission");
        if (StringUtils.isEmpty((String)userPermission) && (groupPermissions == null || groupPermissions.length == 0)) {
            return true;
        }
        if (userPermission != null && user != null && userPermission.equals(user.getName())) {
            return true;
        }
        if (groupPermissions == null || groupPermissions.length == 0) {
            return false;
        }
        List<String> groups = Arrays.asList(groupPermissions);
        for (String groupName : this.userAccessor.getGroupNames(user)) {
            if (!groups.contains(groupName)) continue;
            return true;
        }
        return false;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public SpacePermissionManager getSpacePermissionManager() {
        return this.spacePermissionManager;
    }

    public BootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }

    public ContentEntityManager getContentEntityManager() {
        return this.contentEntityManager;
    }

    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }
}

