/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.event;

import com.atlassian.confluence.ext.usage.event.ThrottlingRejectedExecutionHandler;
import com.atlassian.confluence.ext.usage.event.UsageEventWrapperTask;
import com.atlassian.confluence.ext.usage.index.UsageIndexManager;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class UsageTaskQueue {
    private static final int QUEUE_CAPACITY = 1000;
    private static final Logger log = Logger.getLogger(UsageTaskQueue.class);
    private UsageIndexManager usageIndexManager;
    private final ThreadPoolExecutor executor = this.createExecutor();

    private ThreadPoolExecutor createExecutor() {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(1000);
        ThrottlingRejectedExecutionHandler handler = new ThrottlingRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                log.error((Object)"Discarding usage event(s) because task queue is full. Usage statistics may not be accurate.");
            }
        });
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, queue, handler);
    }

    public Future<?> addTask(final UsageEventWrapperTask task) {
        return this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("UsageEventListener.run: " + task));
                }
                try {
                    UsageTaskQueue.this.usageIndexManager.index(task);
                }
                catch (Throwable t) {
                    log.error((Object)("Error indexing task: " + task + ": " + t), t);
                }
            }
        });
    }

    public boolean waitUntilQueueProcessed(long timeoutMillis) {
        Future<Boolean> future = this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return true;
            }
        });
        try {
            return future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    Queue<Runnable> getQueue() {
        return new LinkedList<Runnable>(this.executor.getQueue());
    }

    public void setUsageIndexManager(UsageIndexManager usageIndexManager) {
        this.usageIndexManager = usageIndexManager;
    }
}

