/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.event;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.space.SpaceEvent;
import com.atlassian.confluence.event.events.types.Created;
import com.atlassian.confluence.event.events.types.Removed;
import com.atlassian.confluence.event.events.types.Updated;
import com.atlassian.confluence.event.events.types.Viewed;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.task.Task;
import com.atlassian.event.Event;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;

public class UsageEventWrapperTask
implements Task {
    private Date dateFired = new Date();
    private Document document;
    private String eventType;
    private String entityType;
    private long entityId;
    private long spaceId;

    public UsageEventWrapperTask(Event event, Extractor extractor) {
        this.initDocument(event, extractor);
    }

    public void execute() throws Exception {
        throw new UnsupportedOperationException("Task shouldn't be executed directly");
    }

    public Date getDateFired() {
        return this.dateFired;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public long getSpaceId() {
        return this.spaceId;
    }

    public String toString() {
        return "UsageEventWrapperTask: " + this.eventType + ":" + this.entityType + "(" + this.entityId + ") at " + this.dateFired;
    }

    public Document getDocument() {
        return this.document;
    }

    public void initDocument(Event e, Extractor extractor) {
        ContentEvent contentEvent;
        String user;
        this.document = new Document();
        this.document.add((IndexableField)new Field("date", DateTools.dateToString((Date)this.getDateFired(), (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (e instanceof Viewed) {
            this.eventType = "view";
        } else if (e instanceof Updated) {
            this.eventType = "update";
        } else if (e instanceof Created) {
            this.eventType = "create";
        } else if (e instanceof Removed) {
            this.eventType = "remove";
        }
        if (this.eventType != null) {
            this.document.add((IndexableField)new Field("eventType", this.eventType, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (e instanceof PageEvent) {
            this.entityType = "page";
        } else if (e instanceof SpaceEvent) {
            this.entityType = "space";
        } else if (e instanceof CommentEvent) {
            this.entityType = "comment";
        } else if (e instanceof BlogPostEvent) {
            this.entityType = "blogpost";
        }
        if (this.entityType != null) {
            this.document.add((IndexableField)new Field("entityType", this.entityType, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (e instanceof ContentEvent) {
            this.entityId = ((ContentEvent)e).getContent().getId();
        } else if (e instanceof SpaceEvent) {
            this.entityId = ((SpaceEvent)e).getSpace().getId();
        }
        this.document.add((IndexableField)new Field("entity", Long.toString(this.entityId), Field.Store.YES, Field.Index.NOT_ANALYZED));
        Space eventSpace = null;
        if (e instanceof PageEvent) {
            eventSpace = ((PageEvent)e).getPage().getSpace();
        } else if (e instanceof CommentEvent) {
            eventSpace = ((CommentEvent)e).getComment().getPage().getSpace();
        } else if (e instanceof BlogPostEvent) {
            eventSpace = ((BlogPostEvent)e).getBlogPost().getSpace();
        } else if (e instanceof SpaceEvent) {
            eventSpace = ((SpaceEvent)e).getSpace();
        }
        if (eventSpace != null) {
            this.spaceId = eventSpace.getId();
            this.document.add((IndexableField)new Field("space", Long.toString(this.spaceId), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if ((user = AuthenticatedUserThreadLocal.getUsername()) != null) {
            this.document.add((IndexableField)new Field("user", user, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (e instanceof ContentEvent && (contentEvent = (ContentEvent)e).getContent() instanceof Searchable && extractor != null) {
            extractor.addFields(this.document, null, (Searchable)contentEvent.getContent());
        }
    }
}

