/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.event;

import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostViewEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.event.events.types.Viewed;
import com.atlassian.confluence.ext.usage.event.UsageEventWrapperTask;
import com.atlassian.confluence.ext.usage.event.UsageTaskQueue;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageEventListener
implements EventListener {
    private static final Logger log = LoggerFactory.getLogger(UsageEventListener.class);
    private PluginAccessor pluginAccessor;
    private UsageTaskQueue taskQueue;
    private static final Class[] HANDLED_EVENT_CLASSES = new Class[]{PageViewEvent.class, PageCreateEvent.class, PageUpdateEvent.class, PageRemoveEvent.class, BlogPostViewEvent.class, BlogPostCreateEvent.class, BlogPostUpdateEvent.class, BlogPostRemoveEvent.class, SpaceCreateEvent.class, SpaceRemoveEvent.class, CommentCreateEvent.class, CommentRemoveEvent.class};

    public void handleEvent(Event confluenceEvent) {
        if (log.isDebugEnabled()) {
            log.debug("UsageEventListener.handleEvent: " + confluenceEvent);
        }
        if (this.isHistoricalContentViewEvent(confluenceEvent)) {
            return;
        }
        Extractor contentPermissionExtractor = this.getContentPermissionExtractor();
        if (contentPermissionExtractor == null) {
            log.error("Error getting confluence.extractors.core:contentPermissionsExtractor. This can result in missing searchable fields.");
        }
        try {
            this.taskQueue.addTask(new UsageEventWrapperTask(confluenceEvent, contentPermissionExtractor));
        }
        catch (Throwable t) {
            log.error("Error creating task to index for event:" + confluenceEvent + " : " + t, t);
        }
    }

    private boolean isHistoricalContentViewEvent(Event event) {
        if (event instanceof Viewed && event instanceof ContentEvent) {
            ContentEntityObject content = ((ContentEvent)event).getContent();
            return !content.isLatestVersion();
        }
        return false;
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENT_CLASSES;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setUsageTaskQueue(UsageTaskQueue taskQueue) {
        this.taskQueue = taskQueue;
    }

    private Extractor getContentPermissionExtractor() {
        ModuleDescriptor extractorDescriptor = this.pluginAccessor.getEnabledPluginModule("confluence.extractors.core:contentPermissionsExtractor");
        if (extractorDescriptor != null) {
            return (Extractor)extractorDescriptor.getModule();
        }
        return null;
    }
}

