require([
    "jquery",
    "shc/ajs",
    "shc/location"
], function($, AJS, location) {

    if (!location.isSupportTools()) {
        // Exit if we are not on the STP screen.
        return;
    }

    var user = $('meta[name=ajs-remote-user]').attr('content');
    var severityUrl = AJS.contextPath() + '/rest/supportHealthCheck/1.0/user-setting/'+ user + '/notification-severity';

    AJS.toInit(function() {
        var containerDeferred = $.Deferred();
        var preferencesDeferred = $.getJSON(severityUrl);

        // Load the notification config panel once the healthContainerLoadedEvent event is triggered
        // AND the UserPreferences REST call has returned.
        AJS.bind("healthContainerLoadedEvent", containerDeferred.resolve);

        $.when(containerDeferred, preferencesDeferred).done(renderConfigPanel);
    });

    // containerResult is just used for padding with the $.when callback.
    function renderConfigPanel(containerResult, preferencesResult) {
        var severity = preferencesResult[0];
        var notificationConfig = $(Support.HealthCheck.Templates.notificationConfig());
        var severitySelect = notificationConfig.find('select#notification-settings');
        severitySelect.val(severity.toLowerCase());
        severitySelect.change(updateUserSettings);
        $('.health-status-container').after(notificationConfig);
    }

    // Make a REST call to enable or disable notification for current user
    function updateUserSettings() {

        // Select option corresponds to Severity API Model enum - pass straight through to backend.
        var notificationSeverity = $(this).val();
        $.ajax({
            url: severityUrl,
            type: 'PUT',
            data: JSON.stringify(notificationSeverity),
            contentType: 'application/json'
        })
        .done(function () {
            // NOOP
        })
        .fail(function () {
            console.error('Something went wrong, could not save the notification preference');
        });

        // Trigger Atlassian Analytics event after user updated their settings
        // Available options: [undefined, major, critical], critical is for disabling all notification
        AJS.trigger('analyticsEvent', {
            name: "healthcheck.notification.config.update." + notificationSeverity,
            data: {severity: notificationSeverity}
        });
    }
});