/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.thread;

import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.atlassian.support.healthcheck.concurrent.SupportHealthCheckProcess;
import com.atlassian.support.healthcheck.concurrent.SupportHealthCheckTask;
import com.atlassian.support.healthcheck.impl.ExtendedSupportHealthCheck;
import com.atlassian.support.healthcheck.thread.HealthCheckCallable;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckProcessCallable
implements Callable {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckCallable.class);
    private final SupportHealthCheckProcess process;

    public HealthCheckProcessCallable(SupportHealthCheckProcess process) {
        this.process = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void call() throws Exception {
        Collection<SupportHealthCheckTask> tasks = this.process.getTasks();
        for (SupportHealthCheckTask task : tasks) {
            ExtendedSupportHealthCheck check = (ExtendedSupportHealthCheck)task.getWork();
            SupportHealthStatus status = null;
            try {
                log.info("Invoking health check: {}", (Object)check.getClass().getName());
                status = this.process.run(check);
                if (status == null) continue;
            }
            catch (RuntimeException e) {
                try {
                    status = new SupportHealthStatusFactory(Application.Unknown, "").failed("Exception during check invocation: " + e.getMessage(), SupportHealthStatus.Severity.MAJOR);
                    if (status == null) continue;
                    this.process.complete(check, status);
                    continue;
                }
                catch (Throwable throwable) {
                    if (status != null) {
                        this.process.complete(check, status);
                    }
                    throw throwable;
                }
            }
            this.process.complete(check, status);
        }
        return null;
    }
}

