/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.scheduler;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.support.healthcheck.api.HealthCheckService;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPersistenceService;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPropertiesPersistenceService;
import com.atlassian.support.healthcheck.persistence.service.NotificationDismissPersistenceService;
import com.atlassian.support.healthcheck.scheduler.HealthCheckJob;
import com.atlassian.support.healthcheck.scheduler.HealthCheckRunner;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckRunnerImpl
implements HealthCheckRunner,
LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(HealthCheckRunnerImpl.class);
    private static final String JOB_NAME = HealthCheckRunnerImpl.class.getName() + ":job";
    private final HealthStatusPersistenceService healthStatusPersistenceService;
    private final HealthStatusPropertiesPersistenceService healthStatusPropertiesPersistenceService;
    private final NotificationDismissPersistenceService notificationDismissPersistenceService;
    private final PluginScheduler pluginScheduler;
    private final HealthCheckService healthCheckService;
    private final EventPublisher eventPublisher;
    private HashMap<String, Object> jobData = new HashMap();
    private long interval = 86400000L;
    private Date lastRun = null;

    public HealthCheckRunnerImpl(HealthStatusPersistenceService healthStatusPersistenceService, HealthStatusPropertiesPersistenceService healthStatusPropertiesPersistenceService, NotificationDismissPersistenceService notificationDismissPersistenceService, PluginScheduler pluginScheduler, HealthCheckService healthCheckService, EventPublisher eventPublisher) {
        this.healthStatusPersistenceService = healthStatusPersistenceService;
        this.healthStatusPropertiesPersistenceService = healthStatusPropertiesPersistenceService;
        this.notificationDismissPersistenceService = notificationDismissPersistenceService;
        this.pluginScheduler = pluginScheduler;
        this.healthCheckService = healthCheckService;
        this.eventPublisher = eventPublisher;
    }

    public static String getJobName() {
        return JOB_NAME;
    }

    public long getInterval() {
        return this.interval;
    }

    public Date getLastRun() {
        return this.lastRun;
    }

    void setLastRun(Date lastRun) {
        this.lastRun = lastRun;
    }

    @Override
    public void reschedule(long interval) {
        this.interval = interval;
        this.jobData.put("healthCheckService", this.healthCheckService);
        this.jobData.put("healthStatusPersistenceService", this.healthStatusPersistenceService);
        this.jobData.put("healthStatusPropertiesPersistenceService", this.healthStatusPropertiesPersistenceService);
        this.jobData.put("notificationDismissPersistenceService", this.notificationDismissPersistenceService);
        this.jobData.put("eventPublisher", this.eventPublisher);
        this.pluginScheduler.scheduleJob(JOB_NAME, HealthCheckJob.class, this.jobData, new Date(System.currentTimeMillis() + 60000L), interval);
        logger.debug(String.format("Scheduled Healthcheck Job running every %dms", interval));
    }

    public void onStart() {
        try {
            logger.debug("Removing the old job if applicable...");
            this.pluginScheduler.unscheduleJob(JOB_NAME);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Attempting to remove the previous job failed - likely because it did not exist previously. This should be safe to ignore");
        }
        logger.debug("Scheduling the job");
        this.reschedule(this.interval);
        logger.debug("Startup complete");
    }
}

