/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.support.healthcheck.api.HealthCheckService;
import com.atlassian.support.healthcheck.api.model.HealthCheck;
import com.atlassian.support.healthcheck.api.model.HealthCheckFilter;
import com.atlassian.support.healthcheck.api.model.HealthCheckProcessReport;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatusReport;
import com.atlassian.support.healthcheck.api.model.HealthChecks;
import com.atlassian.support.healthcheck.api.model.exception.InvalidHealthCheckFilterException;
import com.atlassian.support.healthcheck.impl.ExtendedSupportHealthCheck;
import com.atlassian.support.healthcheck.impl.SupportHealthCheckManager;
import com.atlassian.support.healthcheck.persistence.NotificationParam;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPropertiesPersistenceService;
import com.atlassian.support.healthcheck.persistence.service.NotificationDismissPersistenceService;
import com.atlassian.support.healthcheck.rest.HealthCheckPropertiesRepresentation;
import com.atlassian.support.healthcheck.util.SupportHealthCheckUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
public class HealthCheckResource {
    private final HealthStatusPropertiesPersistenceService healthStatusPropertiesPersistenceService;
    private final NotificationDismissPersistenceService notificationService;
    private final SupportHealthCheckManager healthCheckManager;
    private final HealthCheckService healthCheckService;
    private final UserManager userManager;
    private final TimeZoneManager timeZoneManager;

    public HealthCheckResource(HealthStatusPropertiesPersistenceService healthStatusPropertiesPersistenceService, NotificationDismissPersistenceService notificationService, SupportHealthCheckManager healthCheckManager, HealthCheckService healthCheckService, UserManager userManager, TimeZoneManager timeZoneManager) {
        this.healthStatusPropertiesPersistenceService = healthStatusPropertiesPersistenceService;
        this.notificationService = notificationService;
        this.healthCheckManager = healthCheckManager;
        this.healthCheckService = healthCheckService;
        this.userManager = userManager;
        this.timeZoneManager = timeZoneManager;
    }

    @Path(value="/check")
    @GET
    public HealthCheckStatusReport check() {
        return this.healthCheckService.runChecks(HealthCheckFilter.ALL);
    }

    @Path(value="/check/{username}")
    @GET
    public HealthCheckStatusReport getStatusesForUser(@PathParam(value="username") String username) {
        UserKey userkey = SupportHealthCheckUtils.getUserKey(this.userManager, username);
        return this.healthCheckService.getStatusesForUserNotifications(userkey);
    }

    @Path(value="/checkDetails")
    @GET
    public Response checkDetails(@QueryParam(value="key") Set<String> healthCheckKeys, @QueryParam(value="tag") Set<String> healthCheckTags) {
        try {
            HealthCheckFilter filter = HealthCheckFilter.builder().keys(healthCheckKeys).tags(healthCheckTags).build();
            return Response.ok((Object)this.healthCheckService.runChecks(filter)).build();
        }
        catch (InvalidHealthCheckFilterException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/check/process")
    @POST
    public Response startHealthCheckProcess() {
        Collection<ExtendedSupportHealthCheck> healthChecks = this.healthCheckManager.getHealthChecks(HealthCheckFilter.ALL);
        UUID processId = this.healthCheckManager.startCheckProcess(HealthCheckFilter.ALL);
        Collection<HealthCheck> representation = this.checksToCheckJsonRepresentation(healthChecks);
        return Response.ok((Object)HealthCheckProcessReport.builder().processId(processId).checks(new HealthChecks(representation)).build()).build();
    }

    @Path(value="/check/process/{processId}/results")
    @GET
    public Response getResultsFromProcess(@PathParam(value="processId") String processId) {
        if (processId != null) {
            try {
                UUID uuid = UUID.fromString(processId);
                HealthCheckStatusReport statusReport = this.healthCheckService.getCheckResultsFromProcess(uuid);
                if (statusReport != null) {
                    return Response.ok((Object)statusReport).build();
                }
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="/list")
    @GET
    public Response list() {
        Collection<ExtendedSupportHealthCheck> healthChecks = this.healthCheckManager.getHealthChecks(HealthCheckFilter.ALL);
        return Response.ok((Object)new HealthChecks(this.checksToCheckJsonRepresentation(healthChecks))).build();
    }

    @Path(value="/dismissNotification")
    @POST
    public Response dismissNotification(NotificationParam params) {
        UserKey userkey = SupportHealthCheckUtils.getUserKey(this.userManager, params.getUsername());
        this.notificationService.storeDismissedNotification(userkey, params.getNotificationId(), params.getIsSnoozed());
        return Response.noContent().build();
    }

    @Path(value="/dismissNotification/{username}/{notificationId}")
    @GET
    public Response isAutoDismissed(@PathParam(value="username") String username, @PathParam(value="notificationId") Integer notificationId) {
        UserKey userkey = SupportHealthCheckUtils.getUserKey(this.userManager, username);
        Boolean isAutoDismissed = this.notificationService.checkIsAutoDismissed(userkey, notificationId);
        if (isAutoDismissed.booleanValue()) {
            return Response.status((int)200).build();
        }
        return Response.noContent().build();
    }

    @Path(value="/lastRun")
    @GET
    public Response getLastRun() {
        HealthCheckPropertiesRepresentation propRepresentation = this.healthStatusPropertiesPersistenceService.getPropertiesRepresentation("last-run");
        if (propRepresentation != null) {
            long timeStamp = Long.valueOf(propRepresentation.getPropertyValue());
            String formattedDate = SupportHealthCheckUtils.formatRelativeDate(timeStamp, this.timeZoneManager);
            return Response.ok((Object)new HealthCheckPropertiesRepresentation("Scheduler Last Run", formattedDate)).build();
        }
        return Response.noContent().build();
    }

    @ExperimentalApi
    @Path(value="/deleteDismiss/{username}")
    @GET
    public Response deleteDismiss(@PathParam(value="username") String username) {
        UserKey userkey = SupportHealthCheckUtils.getUserKey(this.userManager, username);
        this.notificationService.deleteDismissByUser(userkey);
        return Response.noContent().build();
    }

    private Collection<HealthCheck> checksToCheckJsonRepresentation(Collection<ExtendedSupportHealthCheck> healthChecks) {
        return Collections2.transform(healthChecks, (Function)new Function<ExtendedSupportHealthCheck, HealthCheck>(){

            public HealthCheck apply(ExtendedSupportHealthCheck check) {
                return SupportHealthCheckUtils.asHealthCheckJson(check);
            }
        });
    }
}

