/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.persistence.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.support.healthcheck.persistence.ao.SupportHealthcheckSchema;
import com.atlassian.support.healthcheck.persistence.service.NotificationDismissPersistenceService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.java.ao.ActiveObjectsException;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationDismissPersistenceServiceImpl
implements NotificationDismissPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(NotificationDismissPersistenceServiceImpl.class);
    private final ActiveObjects ao;

    public NotificationDismissPersistenceServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public void storeDismissedNotification(UserKey userkey, Integer notificationId, Boolean isSnoozed) {
        Date currentDate = new Date();
        if (isSnoozed.booleanValue()) {
            SupportHealthcheckSchema.HealthCheckNotificationDismiss[] existingEntities = this.getSnoozedNotificationByUserAndId(userkey, notificationId);
            if (existingEntities.length > 0) {
                for (SupportHealthcheckSchema.HealthCheckNotificationDismiss entity : existingEntities) {
                    int snoozeCount = entity.getSnoozeCount() + 1;
                    if (snoozeCount < 3) {
                        entity.setSnoozeDate(currentDate);
                        entity.setSnoozeCount(snoozeCount);
                        entity.save();
                        continue;
                    }
                    entity.setIsSnoozed(false);
                    entity.save();
                }
            } else {
                this.addNewNotificationEntity(userkey, notificationId, true, currentDate, 1);
            }
        } else {
            this.addNewNotificationEntity(userkey, notificationId, false, null, null);
        }
    }

    @Override
    public List<Integer> getDismissedNotificationByUser(UserKey userkey) {
        ArrayList notificationsId = Lists.newArrayList();
        Date aDayAgo = DateUtils.addDays((Date)new Date(), (int)-1);
        try {
            for (SupportHealthcheckSchema.HealthCheckNotificationDismiss notification : (SupportHealthcheckSchema.HealthCheckNotificationDismiss[])this.ao.find(SupportHealthcheckSchema.HealthCheckNotificationDismiss.class, Query.select().where("USER_KEY = ? AND IS_SNOOZED = ?", new Object[]{userkey.getStringValue(), Boolean.FALSE}))) {
                notificationsId.add(notification.getNotificationId());
            }
            for (SupportHealthcheckSchema.HealthCheckNotificationDismiss notification : (SupportHealthcheckSchema.HealthCheckNotificationDismiss[])this.ao.find(SupportHealthcheckSchema.HealthCheckNotificationDismiss.class, Query.select().where("USER_KEY = ? AND IS_SNOOZED = ? AND SNOOZE_DATE > ?", new Object[]{userkey.getStringValue(), Boolean.TRUE, aDayAgo}))) {
                notificationsId.add(notification.getNotificationId());
            }
        }
        catch (ActiveObjectsException e) {
            log.error("There's an error retrieving dismissed flag for user {}", (Object)userkey);
            e.printStackTrace();
        }
        return notificationsId;
    }

    @Override
    public Boolean checkIsAutoDismissed(UserKey userkey, Integer notificationId) {
        SupportHealthcheckSchema.HealthCheckNotificationDismiss[] entity = (SupportHealthcheckSchema.HealthCheckNotificationDismiss[])this.ao.find(SupportHealthcheckSchema.HealthCheckNotificationDismiss.class, Query.select().where("USER_KEY = ? AND NOTIFICATION_ID = ? AND IS_SNOOZED = ?", new Object[]{userkey.getStringValue(), notificationId, Boolean.FALSE}));
        return entity.length > 0;
    }

    @Override
    public void deleteDismissByUser(UserKey userkey) {
        this.ao.deleteWithSQL(SupportHealthcheckSchema.HealthCheckNotificationDismiss.class, "USER_KEY = ?", new Object[]{userkey.getStringValue()});
    }

    @Override
    public void deleteDismissById(List<Integer> removedStatusIds) {
        for (Integer id : removedStatusIds) {
            this.ao.deleteWithSQL(SupportHealthcheckSchema.HealthCheckNotificationDismiss.class, "NOTIFICATION_ID = ?", new Object[]{id});
        }
    }

    private void addNewNotificationEntity(UserKey userkey, Integer notificationId, Boolean isSnoozed, Date currentDate, Integer snoozeCount) {
        try {
            SupportHealthcheckSchema.HealthCheckNotificationDismiss notificationEntity = (SupportHealthcheckSchema.HealthCheckNotificationDismiss)this.ao.create(SupportHealthcheckSchema.HealthCheckNotificationDismiss.class, new DBParam[]{new DBParam("USER_KEY", (Object)userkey.getStringValue()), new DBParam("NOTIFICATION_ID", (Object)notificationId), new DBParam("IS_SNOOZED", (Object)isSnoozed), new DBParam("SNOOZE_DATE", (Object)currentDate), new DBParam("SNOOZE_COUNT", (Object)snoozeCount)});
            notificationEntity.save();
        }
        catch (ActiveObjectsException e) {
            log.error("There's a problem persisting notification dismiss flag into the database for the user {}", (Object)userkey.toString());
            e.printStackTrace();
        }
    }

    private SupportHealthcheckSchema.HealthCheckNotificationDismiss[] getSnoozedNotificationByUserAndId(UserKey userkey, Integer notificationId) {
        return (SupportHealthcheckSchema.HealthCheckNotificationDismiss[])this.ao.find(SupportHealthcheckSchema.HealthCheckNotificationDismiss.class, Query.select().where("USER_KEY = ? AND NOTIFICATION_ID = ? AND IS_SNOOZED = ?", new Object[]{userkey.getStringValue(), notificationId, Boolean.TRUE}));
    }
}

