/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.persistence.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.support.healthcheck.persistence.ao.SupportHealthcheckSchema;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPropertiesPersistenceService;
import com.atlassian.support.healthcheck.rest.HealthCheckPropertiesRepresentation;
import java.util.Arrays;
import java.util.Iterator;
import net.java.ao.ActiveObjectsException;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthStatusPropertiesPersistenceServiceImpl
implements HealthStatusPropertiesPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(HealthStatusPropertiesPersistenceServiceImpl.class);
    private final ActiveObjects ao;

    public HealthStatusPropertiesPersistenceServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public void storeProperties(String propertyName, String propertyValue) {
        try {
            Iterable<SupportHealthcheckSchema.SupportHealthStatusProperties> properties = this.getPropertiesValue(propertyName);
            if (properties.iterator().hasNext()) {
                this.updateProperties(properties, propertyValue);
            } else {
                SupportHealthcheckSchema.SupportHealthStatusProperties newProperty = (SupportHealthcheckSchema.SupportHealthStatusProperties)this.ao.create(SupportHealthcheckSchema.SupportHealthStatusProperties.class, new DBParam[]{new DBParam("PROPERTY_NAME", (Object)propertyName), new DBParam("PROPERTY_VALUE", (Object)propertyValue)});
                newProperty.save();
            }
        }
        catch (ActiveObjectsException ex) {
            log.error("There's a problem persisting the property {} into the database", (Object)propertyName);
            ex.printStackTrace();
        }
    }

    @Override
    public void updateProperties(Iterable<SupportHealthcheckSchema.SupportHealthStatusProperties> properties, String propertyValue) {
        try {
            for (SupportHealthcheckSchema.SupportHealthStatusProperties entity : properties) {
                entity.setPropertyValue(propertyValue);
                entity.save();
            }
        }
        catch (ActiveObjectsException ex) {
            log.error("There's a problem updating the property {} in the database", (Object)properties.iterator().next().getPropertyName());
            ex.printStackTrace();
        }
    }

    @Override
    public Iterable<SupportHealthcheckSchema.SupportHealthStatusProperties> getPropertiesValue(String propertyName) {
        return Arrays.asList(this.ao.find(SupportHealthcheckSchema.SupportHealthStatusProperties.class, Query.select().where("PROPERTY_NAME = ?", new Object[]{propertyName})));
    }

    @Override
    public HealthCheckPropertiesRepresentation getPropertiesRepresentation(String propertyName) {
        Iterator<SupportHealthcheckSchema.SupportHealthStatusProperties> properties = this.getPropertiesValue(propertyName).iterator();
        if (properties.hasNext()) {
            SupportHealthcheckSchema.SupportHealthStatusProperties entity = properties.next();
            return new HealthCheckPropertiesRepresentation(entity.getPropertyName(), entity.getPropertyValue());
        }
        return null;
    }

    @Override
    public void removeProperties(String propertyName) {
        for (SupportHealthcheckSchema.SupportHealthStatusProperties entity : this.getPropertiesValue(propertyName)) {
            this.ao.delete(new RawEntity[]{entity});
        }
    }
}

