/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.impl;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.api.HealthCheckService;
import com.atlassian.support.healthcheck.api.HealthCheckUserSettingsService;
import com.atlassian.support.healthcheck.api.model.HealthCheckFilter;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatus;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatusReport;
import com.atlassian.support.healthcheck.impl.SupportHealthCheckManager;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPersistenceService;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPropertiesPersistenceService;
import com.atlassian.support.healthcheck.persistence.service.NotificationDismissPersistenceService;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckServiceImpl
implements HealthCheckService {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckServiceImpl.class);
    private final HealthStatusPersistenceService statusPersistenceService;
    private final NotificationDismissPersistenceService notificationService;
    private final HealthCheckUserSettingsService userSettingsService;
    private final SupportHealthCheckManager healthCheckManager;
    private final HealthStatusPropertiesPersistenceService healthStatusPropertiesPersistenceService;

    public HealthCheckServiceImpl(HealthCheckUserSettingsService userSettingsService, HealthStatusPersistenceService statusPersistenceService, HealthStatusPropertiesPersistenceService healthStatusPropertiesPersistenceService, NotificationDismissPersistenceService notificationService, SupportHealthCheckManager healthCheckManager) {
        this.statusPersistenceService = statusPersistenceService;
        this.notificationService = notificationService;
        this.userSettingsService = userSettingsService;
        this.healthCheckManager = healthCheckManager;
        this.healthStatusPropertiesPersistenceService = healthStatusPropertiesPersistenceService;
    }

    @Override
    public HealthCheckStatusReport getStatusesForUserNotifications(UserKey userKey) {
        SupportHealthStatus.Severity severityThreshold = this.userSettingsService.getUserSettings(userKey).getSeverityThresholdForNotifications();
        List<HealthCheckStatus> failedStatuses = this.statusPersistenceService.getFailedStatuses(severityThreshold);
        if (failedStatuses.isEmpty()) {
            return HealthCheckStatusReport.builder().build();
        }
        final List<Integer> dismissedNotifications = this.notificationService.getDismissedNotificationByUser(userKey);
        ArrayList statuses = Lists.newArrayList((Iterable)Collections2.filter(failedStatuses, (Predicate)new Predicate<HealthCheckStatus>(){

            public boolean apply(HealthCheckStatus status) {
                for (Integer id : dismissedNotifications) {
                    if (status.getId() != id.intValue()) continue;
                    return false;
                }
                return true;
            }
        }));
        return HealthCheckStatusReport.builder().statuses(statuses).build();
    }

    @Override
    public HealthCheckStatusReport runChecks(HealthCheckFilter filter) {
        List<HealthCheckStatus> statuses = this.healthCheckManager.performChecks(filter);
        this.storeHealthStatus(statuses);
        return HealthCheckStatusReport.builder().statuses(statuses).build();
    }

    @Override
    public HealthCheckStatusReport getCheckResultsFromProcess(UUID uuid) {
        List<HealthCheckStatus> statuses = this.healthCheckManager.getCheckResults(uuid);
        if (statuses != null) {
            this.storeHealthStatus(statuses);
            return HealthCheckStatusReport.builder().statuses(statuses).build();
        }
        return null;
    }

    @Override
    public void storeHealthStatus(List<HealthCheckStatus> statuses) {
        this.statusPersistenceService.storeStatuses(statuses);
        this.healthStatusPropertiesPersistenceService.storeProperties("last-run", String.valueOf(DateTimeUtils.currentTimeMillis()));
    }
}

