/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.impl;

import com.atlassian.support.healthcheck.api.OperatingSystemInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.SystemUtils;

public class DefaultOperatingSystemInfo
implements OperatingSystemInfo {
    private final ExtendedOperatingSystemMXBean operatingSystemMXBean = (ExtendedOperatingSystemMXBean)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ExtendedOperatingSystemMXBean.class}, (InvocationHandler)new ExtendedOperatingSystemMXBeanProxy(ManagementFactory.getOperatingSystemMXBean()));

    @Override
    public String getName() {
        return this.operatingSystemMXBean.getName();
    }

    @Override
    public String getArch() {
        return this.operatingSystemMXBean.getArch();
    }

    @Override
    public String getVersion() {
        return this.operatingSystemMXBean.getVersion();
    }

    @Override
    public int getAvailableProcesses() {
        return this.operatingSystemMXBean.getAvailableProcessors();
    }

    @Override
    public double getSystemLoadAverage() {
        return this.operatingSystemMXBean.getSystemLoadAverage();
    }

    @Override
    public long getCommittedVirtualMemorySize() {
        return this.operatingSystemMXBean.getCommittedVirtualMemorySize();
    }

    @Override
    public long getTotalSwapSpaceSize() {
        return this.operatingSystemMXBean.getTotalSwapSpaceSize();
    }

    @Override
    public long getFreeSwapSpaceSize() {
        return this.operatingSystemMXBean.getFreeSwapSpaceSize();
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        return this.operatingSystemMXBean.getTotalPhysicalMemorySize();
    }

    @Override
    public long getFreePhysicalMemorySize() {
        return this.operatingSystemMXBean.getFreePhysicalMemorySize();
    }

    @Override
    public double getSystemCpuLoad() {
        return this.operatingSystemMXBean.getSystemCpuLoad();
    }

    @Override
    public double getProcessCpuLoad() {
        return this.operatingSystemMXBean.getProcessCpuLoad();
    }

    @Override
    public long getMaxFileDescriptorCount() {
        return this.operatingSystemMXBean.getMaxFileDescriptorCount();
    }

    @Override
    public long getOpenFileDescriptorCount() {
        return this.operatingSystemMXBean.getOpenFileDescriptorCount();
    }

    @Override
    public boolean isOsUnix() {
        return SystemUtils.IS_OS_UNIX;
    }

    private static class ExtendedOperatingSystemMXBeanProxy
    implements InvocationHandler {
        private final OperatingSystemMXBean delegate;

        private ExtendedOperatingSystemMXBeanProxy(OperatingSystemMXBean delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
            Method delegateMethod;
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, params);
            }
            try {
                delegateMethod = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                delegateMethod = null;
            }
            if (delegateMethod == null) {
                return this.unknownValue(method.getReturnType());
            }
            delegateMethod.setAccessible(true);
            return delegateMethod.invoke((Object)this.delegate, params);
        }

        private Object unknownValue(Class<?> returnType) {
            if (Integer.TYPE.equals(returnType)) {
                return -1;
            }
            if (Long.TYPE.equals(returnType)) {
                return -1L;
            }
            if (Double.TYPE.equals(returnType)) {
                return -1.0;
            }
            return null;
        }
    }

    private static interface ExtendedOperatingSystemMXBean
    extends OperatingSystemMXBean {
        public long getCommittedVirtualMemorySize();

        public long getTotalSwapSpaceSize();

        public long getFreeSwapSpaceSize();

        public long getFreePhysicalMemorySize();

        public long getTotalPhysicalMemorySize();

        public double getSystemCpuLoad();

        public double getProcessCpuLoad();

        public long getMaxFileDescriptorCount();

        public long getOpenFileDescriptorCount();
    }
}

