/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.impl;

import com.atlassian.support.healthcheck.api.LogFileHelper;
import java.io.File;
import java.io.FileFilter;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class DefaultLogFileHelper
implements LogFileHelper {
    @Override
    public File getCurrentGCLog(File logDir) {
        File currentLog = null;
        WildcardFileFilter fileFilter = new WildcardFileFilter("*gc*.log.*.current");
        File[] files = logDir.listFiles((FileFilter)fileFilter);
        if (files.length > 0) {
            Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            currentLog = files[0];
        }
        return currentLog;
    }

    @Override
    public File getGCLogDir() {
        List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : jvmArgs) {
            if (!arg.contains("Xloggc")) continue;
            return new File(arg.substring(arg.indexOf(":") + 1, arg.lastIndexOf(File.separator)));
        }
        return null;
    }
}

