/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.event;

import com.atlassian.analytics.api.annotations.EventName;

public class HealthcheckScheduledFinishedEvent {
    private final String completeKey;
    private final boolean healthy;
    private final String failureReason;
    private final int severity;

    public HealthcheckScheduledFinishedEvent(String completeKey, boolean healthy, String failureReason, int severity) {
        this.completeKey = completeKey;
        this.healthy = healthy;
        this.failureReason = failureReason;
        this.severity = severity;
    }

    @EventName
    public String eventName() {
        String[] parts = this.completeKey.split(":");
        String healthCheckName = (parts.length > 1 ? parts[1] : this.completeKey).replace("HealthCheck", "").replace("Check", "");
        return "healthchecks.check." + healthCheckName + (this.healthy ? ".pass" : ".fail") + ".done.scheduled";
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public int getSeverity() {
        return this.severity;
    }
}

