/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.concurrent;

import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.impl.ExtendedSupportHealthCheck;
import java.util.concurrent.CountDownLatch;

public class SupportHealthCheckTask<W> {
    private volatile SupportHealthCheckTaskStatus status;
    private volatile SupportHealthStatus healthStatus;
    private final W work;
    private final CountDownLatch completion = new CountDownLatch(1);

    public SupportHealthCheckTask(W work) {
        this.work = work;
        this.status = SupportHealthCheckTaskStatus.QUEUED;
    }

    public SupportHealthCheckTaskStatus getStatus() {
        return this.status;
    }

    public SupportHealthStatus run(ExtendedSupportHealthCheck check) {
        this.status = SupportHealthCheckTaskStatus.RUNNING;
        try {
            return check.check();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void complete(SupportHealthStatus healthStatus) {
        this.status = SupportHealthCheckTaskStatus.COMPLETED;
        this.healthStatus = healthStatus;
        this.completion.countDown();
    }

    public SupportHealthStatus getHealthStatus() throws InterruptedException {
        this.completion.await();
        return this.healthStatus;
    }

    public Object getWork() {
        return this.work;
    }

    public static enum SupportHealthCheckTaskStatus {
        QUEUED,
        RUNNING,
        COMPLETED;

    }
}

