/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.checks;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.atlassian.support.healthcheck.api.FileSystemInfo;
import java.io.Serializable;
import java.util.Optional;

public class ThreadLimitHealthCheck
implements SupportHealthCheck {
    private static final int MIN_THREAD_LIMIT = 4096;
    private static final String HELP_PATH = "healthcheck.threadlimit.url";
    private final I18nResolver i18nResolver;
    private final SupportHealthStatusFactory healthStatusFactory;
    private final FileSystemInfo fileSystemInfo;
    private final Application application;

    public ThreadLimitHealthCheck(I18nResolver i18nResolver, HelpPathResolver helpPathResolver, FileSystemInfo fileSystemInfo, ApplicationProperties properties) {
        this.i18nResolver = i18nResolver;
        this.application = Application.byAppDisplayName(properties.getDisplayName());
        this.healthStatusFactory = new SupportHealthStatusFactory(this.application, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
        this.fileSystemInfo = fileSystemInfo;
    }

    @Override
    public SupportHealthStatus check() {
        Optional<FileSystemInfo.ThreadLimit> threadLimit = this.fileSystemInfo.getThreadLimit();
        if (threadLimit.isPresent()) {
            if (threadLimit.get().greaterThanOrEqualTo(4096)) {
                return this.healthStatusFactory.healthy(this.i18nResolver.getText("healthcheck.threadlimit.valid", new Serializable[]{this.application.name(), Integer.valueOf(4096)}));
            }
            return this.healthStatusFactory.failed(this.i18nResolver.getText("healthcheck.threadlimit.fail", new Serializable[]{this.application.name(), threadLimit.get().toString(), Integer.valueOf(4096)}), SupportHealthStatus.Severity.WARNING);
        }
        return this.healthStatusFactory.healthy(this.i18nResolver.getText("healthcheck.threadlimit.undefined", new Serializable[]{this.application.name(), Integer.valueOf(4096)}));
    }
}

