/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.api.model;

import com.atlassian.support.healthcheck.SupportHealthStatus;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonProperty;

public class HealthCheckStatus {
    @JsonProperty
    private final int id;
    @JsonProperty
    private final String completeKey;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String description;
    @JsonProperty
    private final boolean isHealthy;
    @JsonProperty
    private final String failureReason;
    @JsonProperty
    private final String application;
    @JsonProperty
    private final long time;
    @JsonProperty
    private final SupportHealthStatus.Severity severity;
    @JsonProperty
    private final String documentation;
    @JsonProperty
    private final String tag;

    private HealthCheckStatus() {
        this(HealthCheckStatus.builder());
    }

    private HealthCheckStatus(Builder builder) {
        this.id = builder.id;
        this.completeKey = builder.completeKey;
        this.name = builder.name;
        this.description = builder.description;
        this.isHealthy = builder.isHealthy;
        this.failureReason = builder.failureReason;
        this.application = builder.application;
        this.time = builder.time != 0L ? builder.time : new Date().getTime();
        this.severity = builder.severity;
        this.documentation = builder.documentation;
        this.tag = builder.tag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getId() {
        return this.id;
    }

    public String getCompleteKey() {
        return this.completeKey;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHealthy() {
        return this.isHealthy;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public String getApplication() {
        return this.application;
    }

    public long getTime() {
        return this.time;
    }

    public SupportHealthStatus.Severity getSeverity() {
        return this.severity;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getTag() {
        return this.tag;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ");
        sb.append(this.getName());
        sb.append("\n");
        sb.append("Is healthy: ");
        sb.append(this.isHealthy());
        sb.append("\n");
        sb.append("Failure reason: ");
        sb.append(this.getFailureReason());
        sb.append("\n");
        sb.append("Severity: ");
        sb.append((Object)this.getSeverity());
        sb.append("\n");
        return sb.toString();
    }

    public static class Builder {
        private int id;
        private String completeKey;
        private String name;
        private String description;
        private boolean isHealthy = false;
        private String failureReason;
        private String application;
        private long time;
        private SupportHealthStatus.Severity severity = SupportHealthStatus.Severity.UNDEFINED;
        private String documentation;
        private String tag;

        private Builder() {
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder completeKey(String completeKey) {
            this.completeKey = completeKey;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder isHealthy(boolean isHealthy) {
            this.isHealthy = isHealthy;
            return this;
        }

        public Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public Builder application(String application) {
            this.application = application;
            return this;
        }

        public Builder time(long time) {
            this.time = time;
            return this;
        }

        public Builder severity(SupportHealthStatus.Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public HealthCheckStatus build() {
            return new HealthCheckStatus(this);
        }
    }
}

