/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck;

import com.atlassian.support.healthcheck.Application;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

public interface SupportHealthStatus {
    public boolean isHealthy();

    public String failureReason();

    public Application getApplication();

    public long getTime();

    public String getDocumentation();

    public Severity getSeverity();

    public static enum Severity {
        UNDEFINED,
        MINOR,
        WARNING,
        MAJOR,
        CRITICAL;


        public static Severity valueOf(int severityInt) {
            return Severity.values()[severityInt];
        }

        @JsonCreator
        public static Severity fromString(String name) {
            return Severity.valueOf(name.toUpperCase());
        }

        @JsonValue
        public String stringValue() {
            return this.name().toLowerCase();
        }
    }
}

