/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.common.renderer;

import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Fold;
import com.atlassian.streams.api.common.Function2;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.spi.renderer.Renderers;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

final class ActivityObjectRenderer
implements Function<StreamsEntry.ActivityObject, Option<Html>> {
    private final TemplateRenderer templateRenderer;
    private final boolean withSummary;

    public ActivityObjectRenderer(TemplateRenderer templateRenderer, boolean withSummary) {
        this.templateRenderer = templateRenderer;
        this.withSummary = withSummary;
    }

    public Option<Html> apply(StreamsEntry.ActivityObject o) {
        return ActivityObjectRenderer.titleAsHtml(o).map(this.renderHtml(o));
    }

    private Function<Html, Html> renderHtml(final StreamsEntry.ActivityObject o) {
        return new Function<Html, Html>(){

            public Html apply(Html title) {
                return new Html(Renderers.render((TemplateRenderer)ActivityObjectRenderer.this.templateRenderer, (String)"activity-object-link.vm", (Map)ImmutableMap.of((Object)"activityObject", (Object)o, (Object)"title", (Object)title, (Object)"summary", ActivityObjectRenderer.summaryAsHtml(o), (Object)"withSummary", (Object)ActivityObjectRenderer.this.withSummary)));
            }
        };
    }

    public static Option<Html> titleAsHtml(StreamsEntry.ActivityObject o) {
        return (Option)Fold.foldl((Iterable)o.getTitle(), (Object)o.getTitleAsHtml(), (Function2)new Function2<String, Option<Html>, Option<Html>>(){

            public Option<Html> apply(String title, Option<Html> titleAsHtml) {
                return Option.some((Object)new Html(StringEscapeUtils.escapeHtml((String)title)));
            }
        });
    }

    public static Option<Html> summaryAsHtml(StreamsEntry.ActivityObject o) {
        Iterator iterator = o.getSummary().iterator();
        if (iterator.hasNext()) {
            String summary = (String)iterator.next();
            return Option.some((Object)new Html(StringEscapeUtils.escapeHtml((String)summary)));
        }
        return Option.none();
    }
}

