/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence.renderer;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.renderer.StreamsEntryRendererFactory;
import com.atlassian.streams.confluence.changereport.AttachmentActivityItem;
import com.atlassian.streams.spi.renderer.Renderers;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Map;

public final class AttachmentRendererFactory {
    private final StreamsEntryRendererFactory rendererFactory;
    private final I18nResolver i18nResolver;
    private final TemplateRenderer templateRenderer;
    private final ApplicationProperties applicationProperties;

    public AttachmentRendererFactory(StreamsEntryRendererFactory rendererFactory, I18nResolver i18nResolver, TemplateRenderer templateRenderer, ApplicationProperties applicationProperties) {
        this.rendererFactory = (StreamsEntryRendererFactory)Preconditions.checkNotNull((Object)rendererFactory, (Object)"rendererFactory");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
    }

    public StreamsEntry.Renderer newInstance(Iterable<AttachmentActivityItem.Entry> entries) {
        return new AttachmentRenderer(entries);
    }

    private final Predicate<AttachmentActivityItem.Entry> previewable() {
        return Previewable.INSTANCE;
    }

    private static enum Previewable implements Predicate<AttachmentActivityItem.Entry>
    {
        INSTANCE;


        public boolean apply(AttachmentActivityItem.Entry attachment) {
            return attachment.getPreview().isDefined();
        }
    }

    private final class AttachmentRenderer
    implements StreamsEntry.Renderer {
        private final Function<Iterable<UserProfile>, Html> authorsRenderer;
        private final Function<StreamsEntry.ActivityObject, Option<Html>> targetRenderer;
        private final Iterable<AttachmentActivityItem.Entry> entries;

        public AttachmentRenderer(Iterable<AttachmentActivityItem.Entry> entries) {
            this.authorsRenderer = AttachmentRendererFactory.this.rendererFactory.newAuthorsRenderer();
            this.targetRenderer = AttachmentRendererFactory.this.rendererFactory.newActivityObjectRendererWithSummary();
            this.entries = entries;
        }

        public Html renderTitleAsHtml(StreamsEntry entry) {
            return (Html)entry.getTarget().flatMap(this.targetRenderer).map(this.renderAttachedTo(entry)).getOrElse(this.renderAttached(entry));
        }

        private Supplier<Html> renderAttached(final StreamsEntry entry) {
            return new Supplier<Html>(){

                public Html get() {
                    return new Html(AttachmentRendererFactory.this.i18nResolver.getText("streams.confluence.attached", new Serializable[]{(Serializable)AttachmentRenderer.this.authorsRenderer.apply((Object)entry.getAuthors()), Integer.valueOf(Iterables.size((Iterable)entry.getActivityObjects()))}));
                }
            };
        }

        private Function<Html, Html> renderAttachedTo(final StreamsEntry entry) {
            return new Function<Html, Html>(){

                public Html apply(Html target) {
                    return new Html(AttachmentRendererFactory.this.i18nResolver.getText("streams.confluence.attached.to", new Serializable[]{(Serializable)AttachmentRenderer.this.authorsRenderer.apply((Object)entry.getAuthors()), Integer.valueOf(Iterables.size((Iterable)entry.getActivityObjects())), target}));
                }
            };
        }

        public Option<Html> renderSummaryAsHtml(StreamsEntry entry) {
            return Option.none();
        }

        public Option<Html> renderContentAsHtml(StreamsEntry entry) {
            ImmutableMap context = ImmutableMap.of((Object)"previewable", (Object)ImmutableList.copyOf((Iterable)Iterables.filter(this.entries, (Predicate)AttachmentRendererFactory.this.previewable())), (Object)"nonpreviewable", (Object)ImmutableList.copyOf((Iterable)Iterables.filter(this.entries, (Predicate)Predicates.not((Predicate)AttachmentRendererFactory.this.previewable()))), (Object)"applicationProperties", (Object)AttachmentRendererFactory.this.applicationProperties);
            return Option.some((Object)new Html(Renderers.render((TemplateRenderer)AttachmentRendererFactory.this.templateRenderer, (String)"attachment-content.vm", (Map)context)));
        }
    }
}

