/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence.changereport;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.ActivityVerbs;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Functions;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.confluence.changereport.ActivityItem;
import com.google.common.base.Objects;
import java.util.Date;

public final class AttachmentActivityItem
implements ActivityItem {
    private final Attachment attachment;
    private final Iterable<Entry> entries;
    private final Iterable<StreamsEntry.ActivityObject> activityObjects;
    private final Option<StreamsEntry.ActivityObject> target;
    private final StreamsEntry.Renderer renderer;

    public AttachmentActivityItem(Attachment attachment, Iterable<Entry> entries, Iterable<StreamsEntry.ActivityObject> activityObjects, Option<StreamsEntry.ActivityObject> target, StreamsEntry.Renderer renderer) {
        this.attachment = attachment;
        this.entries = entries;
        this.activityObjects = activityObjects;
        this.target = target;
        this.renderer = renderer;
    }

    @Override
    public Iterable<StreamsEntry.ActivityObject> getActivityObjects() {
        return this.activityObjects;
    }

    @Override
    public String getChangedBy() {
        return this.attachment.getLastModifierName();
    }

    @Override
    public String getContentType() {
        return "attachment";
    }

    @Override
    public String getIconPath() {
        return "/images/icons/attachments/file.gif";
    }

    @Override
    public Long getId() {
        return null;
    }

    @Override
    public Date getModified() {
        return this.attachment.getLastModificationDate();
    }

    @Override
    public StreamsEntry.Renderer getRenderer() {
        return this.renderer;
    }

    @Override
    public int getVersion() {
        return this.attachment.getVersion();
    }

    @Override
    public Option<String> getSpaceKey() {
        if (this.attachment.getSpace() != null) {
            return Option.option((Object)this.attachment.getSpace().getKey());
        }
        return Option.none();
    }

    @Override
    public Option<StreamsEntry.ActivityObject> getTarget() {
        return this.target;
    }

    @Override
    public String getType() {
        return "attachment." + (this.attachment.isNew() ? "added" : "modified");
    }

    @Override
    public String getUrlPath() {
        return this.extractUrlPath(this.attachment);
    }

    @Override
    public ActivityVerb getVerb() {
        return this.attachment.isNew() ? ActivityVerbs.post() : ActivityVerbs.update();
    }

    @Override
    public boolean isAcceptingCommentsFromUser(String username) {
        return false;
    }

    public Iterable<Entry> getAttachments() {
        return this.entries;
    }

    public Attachment getEntity() {
        return this.attachment;
    }

    public boolean matches(Attachment attachment) {
        return Objects.equal((Object)this.getChangedBy(), (Object)attachment.getLastModifierName()) && this.getUrlPath().equals(this.extractUrlPath(attachment)) && Math.abs(this.getModified().getTime() - attachment.getLastModificationDate().getTime()) < 60000L;
    }

    private String extractUrlPath(Attachment attachment) {
        return attachment.getContent().getUrlPath();
    }

    public static final class Preview {
        private final String downloadPath;
        private final int height;
        private final int width;

        public Preview(Attachment attachment, Thumbnail thumbnail) {
            this.downloadPath = attachment.getDownloadPath();
            this.height = thumbnail.getHeight();
            this.width = thumbnail.getWidth();
        }

        public String getDownloadPath() {
            return this.downloadPath;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }
    }

    public static final class Entry {
        private final Attachment attachment;
        private final Option<Preview> preview;

        public Entry(Attachment attachment, Option<Preview> preview) {
            this.attachment = attachment;
            this.preview = preview;
        }

        public String getDownloadPath() {
            return this.attachment.getDownloadPath();
        }

        public String getName() {
            return this.attachment.getFileName();
        }

        public Option<String> getComment() {
            return Option.option((Object)this.attachment.getComment()).flatMap(Functions.trimToNone());
        }

        public Option<Preview> getPreview() {
            return this.preview;
        }
    }
}

