/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence;

import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.confluence.ConfluenceWatchHelper;
import com.atlassian.streams.confluence.ConfluenceWatchInlineActionHandler;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.List;

public class ConfluenceWatchSpaceInlineActionHandler
implements ConfluenceWatchInlineActionHandler<String> {
    private final NotificationManager notificationManager;
    private final SpaceManager spaceManager;
    private final ConfluenceWatchHelper<Space, Long> watchHelper = new ConfluenceWatchHelper();
    private AddSpaceNotification addSpaceNotification = new AddSpaceNotification();
    private GetSpaceNotifications getSpaceNotifications = new GetSpaceNotifications();

    public ConfluenceWatchSpaceInlineActionHandler(NotificationManager notificationManager, SpaceManager spaceManager) {
        this.notificationManager = (NotificationManager)Preconditions.checkNotNull((Object)notificationManager, (Object)"notificationManager");
        this.spaceManager = (SpaceManager)Preconditions.checkNotNull((Object)spaceManager, (Object)"spaceManager");
    }

    @Override
    public boolean startWatching(String key) {
        Space space = this.spaceManager.getSpace(key);
        User user = AuthenticatedUserThreadLocal.getUser();
        if (user != null && this.notificationManager.isUserWatchingPageOrSpace(user, space, null)) {
            return true;
        }
        return this.watchHelper.startWatching(space, this.addSpaceNotification, this.getSpaceNotifications);
    }

    private class GetSpaceNotifications
    implements Function<Space, List<Notification>> {
        private GetSpaceNotifications() {
        }

        public List<Notification> apply(Space entity) {
            return ConfluenceWatchSpaceInlineActionHandler.this.notificationManager.getNotificationsBySpaceAndType(entity, null);
        }
    }

    private class AddSpaceNotification
    implements Function<Pair<User, Space>, Void> {
        private AddSpaceNotification() {
        }

        public Void apply(Pair<User, Space> params) {
            ConfluenceWatchSpaceInlineActionHandler.this.notificationManager.addSpaceNotification((User)params.first(), (Space)params.second(), null);
            return null;
        }
    }
}

