/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence;

import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.confluence.ConfluenceWatchHelper;
import com.atlassian.streams.confluence.ConfluenceWatchInlineActionHandler;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.List;

public class ConfluenceWatchPageInlineActionHandler
implements ConfluenceWatchInlineActionHandler<Long> {
    private final NotificationManager notificationManager;
    private final PageManager pageManager;
    private final ConfluenceWatchHelper<AbstractPage, Long> watchHelper = new ConfluenceWatchHelper();
    private AddPageNotification addPageNotification = new AddPageNotification();
    private GetPageNotifications getPageNotifications = new GetPageNotifications();

    public ConfluenceWatchPageInlineActionHandler(NotificationManager notificationManager, PageManager pageManager) {
        this.notificationManager = (NotificationManager)Preconditions.checkNotNull((Object)notificationManager, (Object)"notificationManager");
        this.pageManager = (PageManager)Preconditions.checkNotNull((Object)pageManager, (Object)"pageManager");
    }

    @Override
    public boolean startWatching(Long key) {
        AbstractPage page = this.pageManager.getAbstractPage(key.longValue());
        User user = AuthenticatedUserThreadLocal.getUser();
        if (user != null && this.notificationManager.isUserWatchingPageOrSpace(user, null, page)) {
            return true;
        }
        return this.watchHelper.startWatching(page, this.addPageNotification, this.getPageNotifications);
    }

    private class GetPageNotifications
    implements Function<AbstractPage, List<Notification>> {
        private GetPageNotifications() {
        }

        public List<Notification> apply(AbstractPage entity) {
            return ConfluenceWatchPageInlineActionHandler.this.notificationManager.getNotificationsByPage(entity);
        }
    }

    private class AddPageNotification
    implements Function<Pair<User, AbstractPage>, Void> {
        private AddPageNotification() {
        }

        public Void apply(Pair<User, AbstractPage> params) {
            ConfluenceWatchPageInlineActionHandler.this.notificationManager.addPageNotification((User)params.first(), (AbstractPage)params.second());
            return null;
        }
    }
}

