/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.search.v2.ChangesSearch;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.ResultFilter;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.filter.SubsetResultFilter;
import com.atlassian.confluence.search.v2.searchfilter.ChainedSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ContentPermissionsSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.LastModifierSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.SiteSearchPermissionsSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.SpacePermissionsSearchFilter;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.StreamsFeed;
import com.atlassian.streams.api.common.Iterables;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Options;
import com.atlassian.streams.api.common.Suppliers;
import com.atlassian.streams.confluence.ConfluenceEntryFactory;
import com.atlassian.streams.confluence.ConfluenceFilterOptionProvider;
import com.atlassian.streams.confluence.ConfluenceFilters;
import com.atlassian.streams.confluence.ConfluenceSearchQueryBuilder;
import com.atlassian.streams.confluence.changereport.ActivityItem;
import com.atlassian.streams.confluence.changereport.ActivityItemFactory;
import com.atlassian.streams.spi.CancellableTask;
import com.atlassian.streams.spi.CancelledException;
import com.atlassian.streams.spi.Filters;
import com.atlassian.streams.spi.StreamsActivityProvider;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ConfluenceStreamsActivityProvider
implements StreamsActivityProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceStreamsActivityProvider.class);
    public static final String PROVIDER_KEY = "wiki";
    private final SearchManager searchManager;
    private final ConfluenceEntryFactory entryFactory;
    private final I18nResolver i18nResolver;
    private final ActivityItemFactory activityItemFactory;

    public ConfluenceStreamsActivityProvider(@Qualifier(value="searchManager") SearchManager searchManager, ConfluenceEntryFactory entryFactory, I18nResolver i18nResolver, ActivityItemFactory activityItemFactory) {
        this.searchManager = (SearchManager)Preconditions.checkNotNull((Object)searchManager, (Object)"searchManager");
        this.entryFactory = (ConfluenceEntryFactory)Preconditions.checkNotNull((Object)entryFactory, (Object)"entryFactory");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.activityItemFactory = (ActivityItemFactory)Preconditions.checkNotNull((Object)activityItemFactory, (Object)"activityItemFactory");
    }

    public CancellableTask<StreamsFeed> getActivityFeed(final ActivityRequest request) {
        return new CancellableTask<StreamsFeed>(){
            final AtomicBoolean cancelled = new AtomicBoolean(false);

            public StreamsFeed call() throws Exception {
                Iterable entries = ConfluenceStreamsActivityProvider.this.getStreamsEntries(request, (Supplier<Boolean>)Suppliers.forAtomicBoolean((AtomicBoolean)this.cancelled));
                return new StreamsFeed(ConfluenceStreamsActivityProvider.this.i18nResolver.getText("portlet.activityfeed.name"), Iterables.take((int)request.getMaxResults(), (Iterable)entries), Option.some((Object)ConfluenceStreamsActivityProvider.this.i18nResolver.getText("portlet.activityfeed.description")));
            }

            public CancellableTask.Result cancel() {
                this.cancelled.set(true);
                return CancellableTask.Result.CANCELLED;
            }
        };
    }

    private Iterable<StreamsEntry> getStreamsEntries(ActivityRequest request, Supplier<Boolean> cancelled) {
        int offset = 0;
        Iterable<ConfluenceEntityObject> searchables = this.search(request, offset, cancelled);
        if (com.google.common.collect.Iterables.isEmpty(searchables)) {
            return ImmutableList.of();
        }
        Iterable<ActivityItem> activityItems = this.activityItemFactory.getActivityItems(searchables, request);
        Iterable<StreamsEntry> entries = this.toStreamsEntries(request, activityItems, cancelled);
        while (com.google.common.collect.Iterables.size(entries) < request.getMaxResults()) {
            searchables = this.search(request, offset += request.getMaxResults(), cancelled);
            if (com.google.common.collect.Iterables.isEmpty(searchables)) {
                return entries;
            }
            activityItems = this.activityItemFactory.getActivityItems(activityItems, searchables, request);
            entries = this.toStreamsEntries(request, activityItems, cancelled);
        }
        return entries;
    }

    private Iterable<StreamsEntry> toStreamsEntries(ActivityRequest request, Iterable<ActivityItem> activityItems, Supplier<Boolean> cancelled) {
        return ImmutableList.copyOf((Iterable)Iterables.take((int)request.getMaxResults(), (Iterable)Options.catOptions((Iterable)com.google.common.collect.Iterables.transform(activityItems, this.toStreamsEntry(request.getContextUri(), cancelled)))));
    }

    private Iterable<ConfluenceEntityObject> search(ActivityRequest request, int startOffset, Supplier<Boolean> cancelled) {
        ISearch search = this.buildSearch(request, startOffset);
        try {
            SearchResults results = this.searchManager.search(search);
            if (com.google.common.collect.Iterables.isEmpty((Iterable)results)) {
                return ImmutableList.of();
            }
            if (((Boolean)cancelled.get()).booleanValue()) {
                throw new CancelledException();
            }
            List entities = this.searchManager.convertToEntities(results, true);
            return com.google.common.collect.Iterables.filter((Iterable)entities, ConfluenceEntityObject.class);
        }
        catch (InvalidSearchException e) {
            log.warn("Invalid search occurred", (Throwable)e);
            return ImmutableList.of();
        }
    }

    private ISearch buildSearch(ActivityRequest request, int startOffset) {
        ImmutableSet authors = ImmutableSet.copyOf((Iterable)Filters.getAuthors((ActivityRequest)request));
        Iterable<String> searchTerms = ConfluenceFilters.getSearchTerms(request);
        Iterable<String> excludedSearchTerms = ConfluenceFilters.getExcludedSearchTerms(request);
        Iterable activityObjectTypes = Filters.getRequestedActivityObjectTypes((ActivityRequest)request, ConfluenceFilterOptionProvider.activities);
        ConfluenceSearchQueryBuilder query = new ConfluenceSearchQueryBuilder().inSpace(Filters.getProjectKeys((ActivityRequest)request)).searchFor(searchTerms).excludeTerms(excludedSearchTerms).activityObjects(activityObjectTypes).minDate((Option<Date>)Filters.getMinDate((ActivityRequest)request)).maxDate((Option<Date>)Filters.getMaxDate((ActivityRequest)request));
        ModifiedSort sort = ModifiedSort.DESCENDING;
        ChainedSearchFilter searchFilter = new ChainedSearchFilter(new SearchFilter[]{SiteSearchPermissionsSearchFilter.getInstance(), SpacePermissionsSearchFilter.getInstance(), ContentPermissionsSearchFilter.getInstance()});
        SubsetResultFilter resultFilter = new SubsetResultFilter(startOffset, request.getMaxResults());
        if (com.google.common.collect.Iterables.isEmpty(searchTerms) && com.google.common.collect.Iterables.isEmpty(excludedSearchTerms)) {
            if (!com.google.common.collect.Iterables.isEmpty((Iterable)authors)) {
                searchFilter = searchFilter.and((SearchFilter)new LastModifierSearchFilter(authors.toArray(new String[com.google.common.collect.Iterables.size((Iterable)authors)])));
            }
            return new ChangesSearch(query.build(), (SearchSort)sort, (SearchFilter)searchFilter, (ResultFilter)resultFilter);
        }
        return new ContentSearch(query.createdOrLastModifiedBy((Iterable<String>)authors).build(), (SearchSort)sort, (SearchFilter)searchFilter, (ResultFilter)resultFilter);
    }

    private Function<ActivityItem, Option<StreamsEntry>> toStreamsEntry(final URI baseUri, final Supplier<Boolean> cancelled) {
        return new Function<ActivityItem, Option<StreamsEntry>>(){

            public Option<StreamsEntry> apply(ActivityItem activityItem) {
                try {
                    if (((Boolean)cancelled.get()).booleanValue()) {
                        throw new CancelledException();
                    }
                    return Option.some((Object)ConfluenceStreamsActivityProvider.this.entryFactory.buildStreamsEntry(baseUri, activityItem));
                }
                catch (Exception e) {
                    log.warn("Error creating streams entry", (Throwable)e);
                    return Option.none();
                }
            }
        };
    }
}

