/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import javax.activation.MimeType;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.parser.ParserOptions;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.util.AbstractResponse;
import org.apache.abdera.protocol.util.CacheControlUtil;
import org.apache.abdera.util.EntityTag;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClientResponse
extends AbstractResponse
implements ClientResponse {
    protected final Abdera abdera;
    protected final Parser parser;
    protected final Date now = new Date();
    protected InputStream in = null;
    protected Date response_date = null;

    protected AbstractClientResponse(Abdera abdera) {
        this.abdera = abdera;
        this.parser = abdera.getParser();
    }

    protected Date initResponseDate() {
        Date date = this.getDateHeader("Date");
        return date != null ? date : this.now;
    }

    protected synchronized Parser getParser() {
        return this.parser;
    }

    @Override
    public <T extends Element> Document<T> getDocument() throws ParseException {
        return this.getDocument(this.getParser());
    }

    @Override
    public <T extends Element> Document<T> getDocument(ParserOptions options) throws ParseException {
        return this.getDocument(this.getParser(), options);
    }

    @Override
    public <T extends Element> Document<T> getDocument(Parser parser) throws ParseException {
        return this.getDocument(parser, parser.getDefaultParserOptions());
    }

    @Override
    public <T extends Element> Document<T> getDocument(Parser parser, ParserOptions options) throws ParseException {
        try {
            String slug;
            String language;
            MimeType mt;
            Date lm;
            IRI cl;
            String charset;
            if (options == null) {
                options = parser.getDefaultParserOptions();
            }
            if ((charset = this.getCharacterEncoding()) != null) {
                options.setCharset(charset);
            }
            if ((cl = this.getContentLocation()) != null && !cl.isAbsolute()) {
                IRI r = new IRI(this.getUri());
                cl = r.resolve(cl);
            }
            String base = cl != null ? cl.toASCIIString() : this.getUri();
            Document doc = parser.parse(this.getReader(), base, options);
            EntityTag etag = this.getEntityTag();
            if (etag != null) {
                doc.setEntityTag(etag);
            }
            if ((lm = this.getLastModified()) != null) {
                doc.setLastModified(lm);
            }
            if ((mt = this.getContentType()) != null) {
                doc.setContentType(mt.toString());
            }
            if ((language = this.getContentLanguage()) != null) {
                doc.setLanguage(language);
            }
            if ((slug = this.getSlug()) != null) {
                doc.setSlug(slug);
            }
            return doc;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public Reader getReader() throws IOException {
        String charset = this.getCharacterEncoding();
        return this.getReader(charset != null ? charset : "UTF-8");
    }

    @Override
    public Reader getReader(String charset) throws IOException {
        if (charset == null) {
            charset = "UTF-8";
        }
        return new InputStreamReader(this.getInputStream(), charset);
    }

    @Override
    public Date getServerDate() {
        if (this.response_date == null) {
            this.response_date = this.initResponseDate();
        }
        return this.response_date;
    }

    protected void parse_cc() {
        String cc = this.getHeader("Cache-Control");
        if (cc != null) {
            CacheControlUtil.parseCacheControl(cc, this);
        }
    }

    @Override
    public String getCharacterEncoding() {
        String charset = null;
        try {
            MimeType mt = this.getContentType();
            if (mt != null) {
                charset = mt.getParameter("charset");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return charset;
    }

    @Override
    public Date getDateHeader(String header) {
        try {
            String value = this.getHeader(header);
            if (value != null) {
                return DateUtil.parseDate(value);
            }
            return null;
        }
        catch (DateParseException e) {
            return null;
        }
    }
}

