/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.task;

import com.atlassian.cache.CacheFactory;
import com.atlassian.support.tools.cache.CacheFactorySupplier;
import com.atlassian.support.tools.task.ClusterMonitoredTaskExecutor;
import com.atlassian.support.tools.task.DefaultMonitoredTaskExecutor;
import com.atlassian.support.tools.task.MonitoredTaskExecutor;
import com.atlassian.support.tools.task.MonitoredTaskExecutorFactory;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMonitoredTaskExecutorFactory
implements MonitoredTaskExecutorFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultMonitoredTaskExecutorFactory.class);
    private final CacheFactorySupplier cacheFactorySupplier;

    public DefaultMonitoredTaskExecutorFactory(@Nonnull CacheFactorySupplier cacheFactorySupplier) {
        this.cacheFactorySupplier = cacheFactorySupplier;
    }

    @Override
    @Nonnull
    public MonitoredTaskExecutor create(@Nonnull String name, int maxThreads) {
        Object cacheFactory = this.cacheFactorySupplier.get();
        if (cacheFactory != null) {
            return new ClusterMonitoredTaskExecutor((CacheFactory)cacheFactory, name, maxThreads);
        }
        log.debug("Using standalone MonitoredTaskExecutor");
        return new DefaultMonitoredTaskExecutor(name, maxThreads);
    }
}

