/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.task;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.support.tools.task.DefaultMonitoredTaskExecutor;
import com.atlassian.support.tools.task.MonitoredCallable;
import com.atlassian.support.tools.task.MutableTaskMonitor;
import com.atlassian.support.tools.task.TaskMonitor;
import com.atlassian.support.tools.task.TaskMonitorListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class ClusterMonitoredTaskExecutor
extends DefaultMonitoredTaskExecutor {
    public static final String TASK_MONITOR_PREFIX = "stp.task.monitor.";
    private static final long PUBLISH_INTERVAL_MS = 100L;
    private final Cache<String, TaskMonitor> clusterMonitors;
    private long publishIntervalMillis = 100L;

    public ClusterMonitoredTaskExecutor(CacheFactory cacheFactory, String name, int maxThreads) {
        super(name, maxThreads);
        this.clusterMonitors = cacheFactory.getCache(TASK_MONITOR_PREFIX + name, null, new CacheSettingsBuilder().expireAfterWrite(2L, TimeUnit.HOURS).remote().build());
    }

    @Override
    public <M extends TaskMonitor> M getMonitor(@Nonnull String id) {
        Object monitor = super.getMonitor(id);
        if (monitor == null) {
            monitor = (TaskMonitor)this.clusterMonitors.get((Object)id);
        }
        return monitor;
    }

    @Override
    public <T, M extends MutableTaskMonitor<T>> M submit(@Nonnull MonitoredCallable<T, M> task) {
        M monitor = super.submit(task);
        this.clusterMonitors.put((Object)monitor.getTaskId(), monitor);
        return monitor;
    }

    @VisibleForTesting
    void setPublishIntervalMillis(long value) {
        this.publishIntervalMillis = value;
    }

    @Override
    protected <T, M extends MutableTaskMonitor<T>> void initMonitor(M monitor, ListenableFutureTask<T> future) {
        super.initMonitor(monitor, future);
        monitor.addListener(new PublishingTaskMonitorListener());
    }

    @Override
    protected void onExpired(MutableTaskMonitor<?> monitor) {
        super.onExpired(monitor);
        this.clusterMonitors.remove((Object)monitor.getTaskId());
    }

    private class PublishingTaskMonitorListener<T>
    implements TaskMonitorListener<T> {
        private long lastPublishedTimestamp = 0L;
        private int lastPublishedPercentage = 0;

        private PublishingTaskMonitorListener() {
        }

        @Override
        public void onFinished(@Nonnull TaskMonitor<T> monitor) {
            this.maybePublish(monitor);
        }

        @Override
        public void onUpdated(@Nonnull TaskMonitor<T> monitor) {
            this.maybePublish(monitor);
        }

        private void maybePublish(TaskMonitor<T> monitor) {
            if (this.lastPublishedPercentage != monitor.getProgressPercentage() || System.currentTimeMillis() - this.lastPublishedTimestamp > ClusterMonitoredTaskExecutor.this.publishIntervalMillis || monitor.getProgressPercentage() == 100 || monitor.isDone()) {
                ClusterMonitoredTaskExecutor.this.clusterMonitors.put((Object)monitor.getTaskId(), monitor);
                this.lastPublishedTimestamp = System.currentTimeMillis();
                this.lastPublishedPercentage = monitor.getProgressPercentage();
            }
        }
    }
}

