/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.servlet;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.support.tools.events.StpSupportZipDownloadEvent;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.servlet.StpServletUtils;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportZipFileServerServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SupportZipFileServerServlet.class);
    private final SupportApplicationInfo applicationInfo;
    private final EventPublisher eventPublisher;
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final WebSudoManager webSudoManager;

    public SupportZipFileServerServlet(SupportApplicationInfo applicationInfo, EventPublisher eventPublisher, TemplateRenderer templateRenderer, UserManager userManager, WebSudoManager webSudoManager) {
        this.applicationInfo = applicationInfo;
        this.eventPublisher = eventPublisher;
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.webSudoManager = webSudoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        StpServletUtils.initializeHeader(res);
        boolean isAdmin = this.isSysAdmin(req, res);
        if (isAdmin) {
            String fileName = req.getParameter("file");
            String filePath = this.applicationInfo.getExportDirectory() + File.separator + fileName;
            boolean isValid = this.isValidSupportZip(fileName);
            File downloadFile = new File(filePath);
            if (isValid && downloadFile.exists()) {
                try (FileInputStream inputStream = new FileInputStream(downloadFile);){
                    this.webSudoManager.willExecuteWebSudoRequest(req);
                    ServletContext context = this.getServletContext();
                    String mimeType = context.getMimeType(fileName);
                    if (mimeType == null) {
                        mimeType = "application/octet-stream";
                    }
                    res.setContentType(mimeType);
                    long fileLength = downloadFile.length();
                    if (fileLength <= Integer.MAX_VALUE) {
                        res.setContentLength((int)fileLength);
                    }
                    String headerKey = "Content-Disposition";
                    String headerValue = String.format("attachment; filename=\"%s\"", downloadFile.getName());
                    res.setHeader(headerKey, headerValue);
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)res.getOutputStream());
                    this.triggerAnalyticsEvent(this.applicationInfo.getApplicationName(), downloadFile.length());
                }
            } else {
                res.setStatus(404);
                this.templateRenderer.render("/templates/html/file-not-found.vm", new HashMap(), (Writer)res.getWriter());
            }
        }
    }

    private boolean isValidSupportZip(String fileName) {
        Pattern fileNamePattern = Pattern.compile("(JIRA|Confluence|Bamboo|FishEye|Bitbucket|Stash|Crowd)_support_([2][0][1-3][0-9])-([0-9]+)-([0-3][0-9])-([0-2][0-9])-([0-5][0-9])-([0-5][0-9]\\.zip)");
        Matcher matcher = fileNamePattern.matcher(fileName);
        return matcher.matches();
    }

    private boolean isSysAdmin(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String username = this.userManager.getRemoteUsername(req);
        if (username == null) {
            res.setStatus(403);
            this.templateRenderer.render("/templates/html/ajax-not-logged-in.vm", new HashMap(), (Writer)res.getWriter());
            return false;
        }
        if (this.userManager.isSystemAdmin(username)) {
            return true;
        }
        res.setStatus(403);
        this.templateRenderer.render("/templates/html/ajax-no-permission.vm", new HashMap(), (Writer)res.getWriter());
        return false;
    }

    private void triggerAnalyticsEvent(String applicationName, long fileSize) {
        StpSupportZipDownloadEvent event = new StpSupportZipDownloadEvent(applicationName, fileSize);
        this.eventPublisher.publish((Object)event);
    }
}

